package com.ximai.mes.restful;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.ximai.common.core.domain.SapAjaxResult;
import com.ximai.framework.security.BasicAuth;
import com.ximai.mes.md.service.IMdItemService;
import com.ximai.mes.md.vo.SapItemVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping(value = "/api/sap/item")
public class SapItemRestController {
    @Autowired
    private IMdItemService mdItemService;

    @ApiOperation(value = "sap产品物料创建")
    @BasicAuth
    @RequestMapping(value = "/sapitemcreate", method = RequestMethod.POST)
    public SapAjaxResult sapItemCreate(@RequestBody String mdItemJson) {


   try{
       //        SapItemVo mdItemVo = JSON.parseObject(mdItemJson).toJavaObject(SapItemVo.class);
//        SapItemVo sapItemVo = JSON.parseObject(mdItemJson, SapItemVo.class);
       List<SapItemVo> sapItemVos = JSON.parseArray(mdItemJson, SapItemVo.class);
       if(CollUtil.isEmpty(sapItemVos) || sapItemVos.size()==0){
           return SapAjaxResult.error("发来的数据为空数据");
       }
       for(SapItemVo sapItem:sapItemVos){
           int i = mdItemService.sapitemCreate(sapItem);
           if(i==1){
               return SapAjaxResult.success("新增成功");
           }
           if(i==2){
               return SapAjaxResult.success("修改成功");
           }
       }
   }catch (Exception e){
       return SapAjaxResult.error(e.getMessage());
   }
   return SapAjaxResult.success("操作成功");
    }
}
