package com.ximai.mes.qt.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.qt.domain.QtFactoryQuote;
import com.ximai.mes.qt.service.IQtFactoryQuoteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 工厂报价Controller
 *
 * @author yinjinlu
 * @date 2024-01-24
 */
@RestController
@RequestMapping("/qt/factoryQuote")
public class QtFactoryQuoteController extends BaseController {
    @Autowired
    private IQtFactoryQuoteService qtFactoryQuoteService;

    /**
     * 查询工厂报价列表
     */
    @PreAuthorize("@ss.hasPermi('qt:factoryQuote:list')")
    @GetMapping("/list")
    public TableDataInfo list(QtFactoryQuote qtFactoryQuote) {
        startPage();
        List<QtFactoryQuote> list = qtFactoryQuoteService.selectQtFactoryQuoteList(qtFactoryQuote);
        return getDataTable(list);
    }

    /**
     * 导出工厂报价列表
     */
    @PreAuthorize("@ss.hasPermi('qt:factoryQuote:export')")
    @Log(title = "工厂报价", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, QtFactoryQuote qtFactoryQuote) {
        List<QtFactoryQuote> list = qtFactoryQuoteService.selectQtFactoryQuoteList(qtFactoryQuote);
        ExcelUtil<QtFactoryQuote> util = new ExcelUtil<QtFactoryQuote>(QtFactoryQuote.class);
        util.exportExcel(response, list, "工厂报价数据");
    }

    /**
     * 获取工厂报价详细信息
     */
    @PreAuthorize("@ss.hasPermi('qt:factoryQuote:query')")
    @GetMapping
    public AjaxResult getInfo(QtFactoryQuote qtFactoryQuote) {
        return AjaxResult.success(qtFactoryQuoteService.selectQtFactoryQuoteById(qtFactoryQuote));
    }

    /**
     * 新增工厂报价
     */
    @PreAuthorize("@ss.hasPermi('qt:factoryQuote:add')")
    @Log(title = "工厂报价", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody QtFactoryQuote qtFactoryQuote) {
        return toAjax(qtFactoryQuoteService.insertQtFactoryQuote(qtFactoryQuote));
    }

    /**
     * 修改工厂报价
     */
    @PreAuthorize("@ss.hasPermi('qt:factoryQuote:edit')")
    @Log(title = "工厂报价", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody QtFactoryQuote qtFactoryQuote) {
        return toAjax(qtFactoryQuoteService.updateQtFactoryQuote(qtFactoryQuote));
    }

    /**
     * 删除工厂报价
     */
    @PreAuthorize("@ss.hasPermi('qt:factoryQuote:remove')")
    @Log(title = "工厂报价", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(qtFactoryQuoteService.deleteQtFactoryQuoteByIds(ids));
    }
}
