package com.ximai.mes.qc.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.core.domain.entity.MdItemType;
import com.ximai.common.exception.ServiceException;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.md.mapper.ItemTypeMapper;
import com.ximai.mes.qc.domain.QcTemplate;
import com.ximai.mes.qc.domain.QcTemplateProcess;
import com.ximai.mes.qc.domain.vo.QcTemplateProcessImportExcel;
import com.ximai.mes.qc.mapper.QcTemplateMapper;
import com.ximai.mes.qc.mapper.QcTemplateProcessMapper;
import com.ximai.mes.qc.service.IQcTemplateProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 检测模板-工序Service业务层处理
 *
 * @author generator
 * @date 2024-02-18
 */
@Service
public class QcTemplateProcessServiceImpl implements IQcTemplateProcessService {
    @Autowired
    private QcTemplateProcessMapper qcTemplateProcessMapper;
    @Autowired
    private QcTemplateMapper qcTemplateMapper;
    @Autowired
    private ItemTypeMapper itemTypeMapper;

    /**
     * 查询检测模板-工序
     *
     * @param id 检测模板-工序主键
     * @return 检测模板-工序
     */
    @Override
    public QcTemplateProcess selectQcTemplateProcessById(Long id) {
        return qcTemplateProcessMapper.selectQcTemplateProcessById(id);
    }

    /**
     * 查询检测模板-工序列表
     *
     * @param qcTemplateProcess 检测模板-工序
     * @return 检测模板-工序
     */
    @Override
    public List<QcTemplateProcess> selectQcTemplateProcessList(QcTemplateProcess qcTemplateProcess) {
        return qcTemplateProcessMapper.selectQcTemplateProcessList(qcTemplateProcess);
    }

    @Override
    public List<QcTemplateProcess> selectListJoinTemplateByQw(QueryWrapper<QcTemplateProcess> query) {
        return qcTemplateProcessMapper.selectListJoinTemplateByQw(query);
    }

    /**
     * 新增检测模板-工序
     *
     * @param qcTemplateProcess 检测模板-工序
     * @return 结果
     */
    @Override
    public int insertQcTemplateProcess(QcTemplateProcess qcTemplateProcess) {
        qcTemplateProcess.createAction();
        return qcTemplateProcessMapper.insertQcTemplateProcess(qcTemplateProcess);
    }

    /**
     * 修改检测模板-工序
     *
     * @param qcTemplateProcess 检测模板-工序
     * @return 结果
     */
    @Override
    public int updateQcTemplateProcess(QcTemplateProcess qcTemplateProcess) {
        qcTemplateProcess.updateAction();
        return qcTemplateProcessMapper.updateQcTemplateProcess(qcTemplateProcess);
    }

    /**
     * 批量删除检测模板-工序
     *
     * @param ids 需要删除的检测模板-工序主键
     * @return 结果
     */
    @Override
    public int deleteQcTemplateProcessByIds(Long[] ids) {
        return qcTemplateProcessMapper.deleteQcTemplateProcessByIds(ids);
    }

    /**
     * 删除检测模板-工序信息
     *
     * @param id 检测模板-工序主键
     * @return 结果
     */
    @Override
    public int deleteQcTemplateProcessById(Long id) {
        return qcTemplateProcessMapper.deleteQcTemplateProcessById(id);
    }

    @Override
    public void importExcel(MultipartFile file, Boolean isUpdateSupport, String operName) throws Exception {
        ExcelUtil<QcTemplateProcessImportExcel> util = new ExcelUtil<QcTemplateProcessImportExcel>(QcTemplateProcessImportExcel.class);
        util.importExcel(file.getInputStream(), s -> {
            String templateName = s.getTemplateName();
            String itemTypeName = s.getItemTypeName();
            MdItemType mdItemType = itemTypeMapper.selectItemTypeByItemTypeName(itemTypeName);
            if (mdItemType == null) {
                throw new ServiceException(String.format("未找到物料分类%s", itemTypeName));
            }
            QcTemplate templateQuery = new QcTemplate();
            List<QcTemplate> templateList = qcTemplateMapper.selectQcTemplateList(templateQuery);
            if (templateList.size() == 0) {
                throw new ServiceException(String.format("未找到检测模版%s", templateName));
            }
            if (isUpdateSupport) {
                QcTemplateProcess query = new QcTemplateProcess();
                query.setTemplateId(templateList.get(0).getId());
                query.setItemTypeId(mdItemType.getItemTypeId());
                query.setProcessName(s.getProcessName());
                List<QcTemplateProcess> tempList = qcTemplateProcessMapper.selectQcTemplateProcessList(query);
                if (tempList.size() != 0) {
                    QcTemplateProcess dbTemp = tempList.get(0);
                    BeanUtil.copyProperties(s, dbTemp);
                    this.updateQcTemplateProcess(dbTemp);
                    return;
                }
            }
            QcTemplateProcess temp = new QcTemplateProcess();
            BeanUtil.copyProperties(s, temp);
            temp.setItemTypeId(mdItemType.getItemTypeId());
            temp.setTemplateId(templateList.get(0).getId());
            this.insertQcTemplateProcess(temp);
        });
    }
}
