package com.ximai.mes.qc.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkorderMapper;
import com.ximai.mes.qc.domain.QcTemplateIndex;
import com.ximai.mes.qc.mapper.QcTemplateIndexMapper;
import com.ximai.mes.qc.service.IQcTemplateIndexService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 检测模板-检测项Service业务层处理
 *
 * @date 2022-05-18
 */
@Service
public class QcTemplateIndexServiceImpl implements IQcTemplateIndexService {
    @Resource
    private QcTemplateIndexMapper qcTemplateIndexMapper;
    @Resource
    private ProWorkorderMapper proWorkorderMapper;

    /**
     * 查询检测模板-检测项
     *
     * @param id 检测模板-检测项主键
     * @return 检测模板-检测项
     */
    @Override
    public QcTemplateIndex selectQcTemplateIndexById(Long id) {
        return qcTemplateIndexMapper.selectQcTemplateIndexById(id);
    }


    @Override
    public List<QcTemplateIndex> selectListByQw(QueryWrapper<QcTemplateIndex> query) {
        return qcTemplateIndexMapper.selectListByQw(query);
    }


    /**
     * 查询检测模板-检测项列表
     *
     * @param qcTemplateIndex 检测模板-检测项
     * @return 检测模板-检测项
     */
    @Override
    public List<QcTemplateIndex> selectQcTemplateIndexList(QcTemplateIndex qcTemplateIndex) {
        return qcTemplateIndexMapper.selectQcTemplateIndexList(qcTemplateIndex);
    }

    /**
     * 新增检测模板-检测项
     *
     * @param qcTemplateIndex 检测模板-检测项
     * @return 结果
     */
    @Override
    public int insertQcTemplateIndex(QcTemplateIndex qcTemplateIndex) {
        qcTemplateIndex.createAction();
        if (StringUtils.isNotEmpty(qcTemplateIndex.getSelectValues())) {
            this.validateSelectValue(qcTemplateIndex.getSelectValues());
        }
        return qcTemplateIndexMapper.insertQcTemplateIndex(qcTemplateIndex);
    }

    /**
     * 修改检测模板-检测项
     *
     * @param qcTemplateIndex 检测模板-检测项
     * @return 结果
     */
    @Override
    public int updateQcTemplateIndex(QcTemplateIndex qcTemplateIndex) {
        qcTemplateIndex.updateAction();
        if (StringUtils.isNotEmpty(qcTemplateIndex.getSelectValues())) {
            this.validateSelectValue(qcTemplateIndex.getSelectValues());
        }
        return qcTemplateIndexMapper.updateQcTemplateIndex(qcTemplateIndex);
    }

    /**
     * 批量删除检测模板-检测项
     *
     * @param ids 需要删除的检测模板-检测项主键
     * @return 结果
     */
    @Override
    public int deleteQcTemplateIndexByIds(Long[] ids) {
        return qcTemplateIndexMapper.deleteQcTemplateIndexByIds(ids);
    }

    /**
     * 删除检测模板-检测项信息
     *
     * @param id 检测模板-检测项主键
     * @return 结果
     */
    @Override
    public int deleteQcTemplateIndexById(Long id) {
        return qcTemplateIndexMapper.deleteQcTemplateIndexById(id);
    }

    @Override
    public int deleteByTemplateId(Long templateId) {
        return qcTemplateIndexMapper.deleteByTemplateId(templateId);
    }

    @Override
    public List<QcTemplateIndex> generateItems(QcTemplateIndex qcTemplateIndex) {
        QueryWrapper<ProWorkorder> proWorkorderQueryWrapper = new QueryWrapper<>();
        boolean workorderCodeIsExsit = StringUtils.isNotEmpty(qcTemplateIndex.getWorkorderCode());
        proWorkorderQueryWrapper.eq(workorderCodeIsExsit, "t1.workorder_code", qcTemplateIndex.getWorkorderCode());
        boolean arrangeCodeIsExsit = StringUtils.isNotEmpty(qcTemplateIndex.getArrangeCode());
        proWorkorderQueryWrapper.eq(arrangeCodeIsExsit, "t1.arrange_code", qcTemplateIndex.getArrangeCode());
        List<ProWorkorder> proWorkorders = null;
        if ((workorderCodeIsExsit && arrangeCodeIsExsit) || workorderCodeIsExsit || arrangeCodeIsExsit) {
            proWorkorders = proWorkorderMapper.selectListByQw(proWorkorderQueryWrapper);
        }
        ExceptionUtil.checkTrueThrowException(CollectionUtil.isEmpty(proWorkorders), "工单不存在");


        ProWorkorder proWorkorder = proWorkorders.get(0);
        QueryWrapper<QcTemplateIndex> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(workorderCodeIsExsit, "t2.workorder_code", qcTemplateIndex.getWorkorderCode());
        queryWrapper.eq(StringUtils.isNotEmpty(qcTemplateIndex.getProcessId()), "t2.process_id", qcTemplateIndex.getProcessId());
        queryWrapper.eq(arrangeCodeIsExsit, "t2.arrange_code", qcTemplateIndex.getArrangeCode());
        queryWrapper.eq(StringUtils.isNotEmpty(qcTemplateIndex.getQcTypes()), "qt.qc_types", qcTemplateIndex.getQcTypes());
        queryWrapper.eq(StringUtils.isNotEmpty(proWorkorder.getItemTypeId()), "t1.item_type_id", proWorkorder.getItemTypeId());
        List<QcTemplateIndex> qcTemplateIndices = qcTemplateIndexMapper.selectListByQw(queryWrapper);

        return qcTemplateIndices;
    }

    private void validateSelectValue(String selectValues) {
//        JSONArray arr = null;
//        try {
//            arr = JSONUtil.parseArray(selectValues);
//        } catch (Exception e) {
//            throw new ServiceException("请检查选择框值格式是否正确");
//        }
//        List<QcIndexInputSelectOption> list = arr.toList(QcIndexInputSelectOption.class);
//        list.forEach(s -> {
//            if (StringUtils.isEmpty(s.getLabel())) {
//                throw new ServiceException("请配置下拉框label属性");
//            }
//            if (s.getValue() == null) {
//                throw new ServiceException("请配置下拉框value属性");
//            }
//        });
    }


}
