package com.ximai.mes.qc.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.constant.QcConst;
import com.ximai.mes.md.domain.MdItem;
import com.ximai.mes.md.mapper.MdItemMapper;
import com.ximai.mes.qc.domain.*;
import com.ximai.mes.qc.mapper.QcIqcLineMapper;
import com.ximai.mes.qc.mapper.QcIqcMapper;
import com.ximai.mes.qc.mapper.QcTemplateIndexMapper;
import com.ximai.mes.qc.mapper.QcTemplateProcessMapper;
import com.ximai.mes.qc.service.IQcIndexService;
import com.ximai.mes.qc.service.IQcIqcLineService;
import com.ximai.mes.qc.service.IQcIqcService;
import com.ximai.mes.qc.service.IQcTemplateIndexService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ximai.mes.constant.QcIqcConst.*;

/**
 * 来料检验单行Service业务层处理
 *
 * @date 2022-05-19
 */
@Service
public class QcIqcLineServiceImpl implements IQcIqcLineService {
    @Resource
    private QcIqcLineMapper qcIqcLineMapper;

    @Resource
    private QcIqcMapper qcIqcMapper;


    @Resource
    private MdItemMapper mdItemMapper;
    @Autowired
    private IQcIqcService qcIqcService;
    @Autowired
    IQcTemplateIndexService
            qcTemplateIndexService;

    @Autowired
    IQcIndexService qcIndexService;
    @Resource
    private QcTemplateProcessMapper qcTemplateProcessMapper;

    @Resource
    private QcTemplateIndexMapper qcTemplateIndexMapper;

    /**
     * 查询来料检验单行
     *
     * @param lineId 来料检验单行主键
     * @return 来料检验单行
     */
    @Override
    public QcIqcLine selectQcIqcLineByLineId(Long lineId) {
        return qcIqcLineMapper.selectQcIqcLineByLineId(lineId);
    }

    /**
     * 查询来料检验单行列表
     *
     * @param qcIqcLine 来料检验单行
     * @return 来料检验单行
     */
    @Override
    public List<QcIqcLine> selectQcIqcLineList(QcIqcLine qcIqcLine) {

        QueryWrapper<QcIqcLine> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(StringUtils.isNotEmpty(qcIqcLine.getIqcCode()), "t2.iqc_code", qcIqcLine.getIqcCode());
        queryWrapper.eq(StringUtils.isNotEmpty(qcIqcLine.getIqcId()), "t2.iqc_id", qcIqcLine.getIqcId());
        queryWrapper.eq(StringUtils.isNotEmpty(qcIqcLine.getSapItemCode()), "mi.sap_item_code", qcIqcLine.getSapItemCode());
        return qcIqcLineMapper.selectListByQw(queryWrapper);
    }

    /**
     * 新增来料检验单行
     *
     * @param qcIqcLine 来料检验单行
     * @return 结果
     */
    @Override
    public int insertQcIqcLine(QcIqcLine qcIqcLine) {
        qcIqcLine.createAction();
        return qcIqcLineMapper.insertQcIqcLine(qcIqcLine);
    }

    /**
     * 修改来料检验单行
     *
     * @param qcIqcLine 来料检验单行
     * @return 结果
     */
    @Override
    public int updateQcIqcLine(QcIqcLine qcIqcLine) {
        qcIqcLine.updateAction();
        return qcIqcLineMapper.updateQcIqcLine(qcIqcLine);
    }

    /**
     * 修改来料检验单行
     *
     * @param qcIqcLine 来料检验单行
     * @return 结果
     */
    @Override
    public int updateObj(QcIqcLine qcIqcLine) {
        Integer status = qcIqcLine.getStatus();
        String statusStr = String.valueOf(status);
        switch (statusStr) {
            case SUCCESS:
                break;
            case FAILD:
            case CANCEL:
                break;
            default:
                break;
        }
        return this.updateQcIqcLine(qcIqcLine);
    }

    @Override
    public int updateCrMajMinQuantity(Long iqcId, Long lineId) {
        QcIqcLine qcIqcLine = new QcIqcLine();
        qcIqcLine.setIqcId(iqcId);
        qcIqcLine.setLineId(lineId);
        return qcIqcLineMapper.updateCrMajMinQuantity(qcIqcLine);
    }

    /**
     * 批量删除来料检验单行
     *
     * @param lineIds 需要删除的来料检验单行主键
     * @return 结果
     */
    @Override
    public int deleteQcIqcLineByLineIds(Long[] lineIds) {
        return qcIqcLineMapper.deleteQcIqcLineByLineIds(lineIds);
    }

    @Override
    public int deleteByIqcId(Long iqcId) {
        return qcIqcLineMapper.deleteByIqcId(iqcId);
    }

    /**
     * 删除来料检验单行信息
     *
     * @param lineId 来料检验单行主键
     * @return 结果
     */
    @Override
    public int deleteQcIqcLineByLineId(Long lineId) {
        return qcIqcLineMapper.deleteQcIqcLineByLineId(lineId);
    }


    @Override
    public int reloadTable(String iqcCode) {

        List<QcIqc> qcIqcs = qcIqcMapper.selectListByQw(new QueryWrapper<QcIqc>().eq("iqc_code", iqcCode));
        QcIqc qcIqc = qcIqcs.get(0);

        ExceptionUtil.checkTrueThrowException(qcIqc != null, "来料检验单不存在,iqcCode:" + iqcCode);


        List<MdItem> mdItems = mdItemMapper.selectListByQw(new QueryWrapper<MdItem>().eq("item_id", qcIqc.getItemId()));
        MdItem mdItem = mdItems.get(0);


        List<QcTemplateProcess> qcTemplateProcesses = qcTemplateProcessMapper.selectListJoinTemplateByQw(new QueryWrapper<QcTemplateProcess>().eq("item_type_id", mdItem.getItemTypeId()).eq("t1.iqc_type", QcConst.IPQC_TABLE));


        if (qcTemplateProcesses.size() == 1) {
            qcIqc.setTemplateId(qcTemplateProcesses.get(0).getTemplateId());

            //先保存
            qcIqcService.updateQcIqc(qcIqc);

            //生成行信息
            generateLine(qcIqc);
        }


        return 0;
    }

    /**
     * 根据头信息生成行信息
     *
     * @param iqc
     */
    private void generateLine(QcIqc iqc) {
        QcTemplateIndex param = new QcTemplateIndex();
        param.setTemplateId(iqc.getTemplateId());
        List<QcTemplateIndex> qcTemplateIndices = qcTemplateIndexService.selectQcTemplateIndexList(param);
        if (CollUtil.isEmpty(qcTemplateIndices)) {
            return;
        }

        QcIndex qcIndex = new QcIndex();
        qcIndex.setIndexIds(qcTemplateIndices.stream().map(x -> x.getIndexId().toString()).distinct().collect(Collectors.toList()));
        List<QcIndex> qcIndices = qcIndexService.selectQcIndexList(qcIndex);
        Map<Long, Integer> inputTypeMap = qcIndices.stream().collect(Collectors.toMap(QcIndex::getIndexId, QcIndex::getInputType));
        for (QcTemplateIndex qcTemplateIndex : qcTemplateIndices) {
            Long indexId = qcTemplateIndex.getIndexId();
            QcIqcLine qcIqcLine = qcTemplateIndex.deepSetObj(QcIqcLine.class);
            qcIqcLine.setIqcId(iqc.getIqcId());
            qcIqcLine.setInputType(inputTypeMap.get(indexId));
            qcIqcLine.setCrQuantity(BigDecimal.ZERO);
            qcIqcLine.setMajQuantity(BigDecimal.ZERO);
            qcIqcLine.setMajQuantity(BigDecimal.ZERO);
            this.insertQcIqcLine(qcIqcLine);
        }
    }

}
