package com.ximai.mes.qc.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.qc.domain.QcIpqc;

import java.util.List;

/**
 * 过程检验单Service接口
 *
 * @date 2022-08-29
 */
public interface IQcIpqcService {
    /**
     * 查询过程检验单
     *
     * @param ipqcId 过程检验单主键
     * @return 过程检验单
     */
    QcIpqc selectQcIpqcByIpqcId(Long ipqcId);

    /**
     * 查询过程检验单列表
     *
     * @param qcIpqc 过程检验单
     * @return 过程检验单集合
     */
    List<QcIpqc> selectQcIpqcList(QcIpqc qcIpqc);

    /**
     * 添加首检单
     *
     * @param qcIpqc 过程检验单
     * @return 过程检验单集合
     */
    void insertInspectionOrder(ProTask proTask, String ipqcType);

    /**
     * 检查检测编码是否唯一
     *
     * @param qcIpqc
     * @return
     */
    String checkIpqcCodeUnique(QcIpqc qcIpqc);

    /**
     * 根据当前传递的过程检验单，查询更多工艺相关信息
     *
     * @param qcIpqc
     * @return
     */
    List<QcIpqc> selectProcessInfoByQw(QueryWrapper<QcIpqc> query);

    /**
     * 新增过程检验单
     *
     * @param qcIpqc 过程检验单
     * @return 结果
     */
    int insertQcIpqc(QcIpqc qcIpqc);

    /**
     * 修改过程检验单
     *
     * @param qcIpqc 过程检验单
     * @return 结果
     */
    int updateQcIpqc(QcIpqc qcIpqc);

    /**
     * 更新头上的cr、maj、min数量
     *
     * @param qcId
     * @return
     */
    int updateCrMajMinQuaAndRate(Long qcId);


    /**
     * 批量删除过程检验单
     *
     * @param ipqcIds 需要删除的过程检验单主键集合
     * @return 结果
     */
    int deleteQcIpqcByIpqcIds(Long[] ipqcIds);

    /**
     * 删除过程检验单信息
     *
     * @param ipqcId 过程检验单主键
     * @return 结果
     */
    int deleteQcIpqcByIpqcId(Long ipqcId);

    int createObj(QcIpqc qcIpqc);

    int updateObj(QcIpqc qcIpqc);
}
