package com.ximai.mes.pro.service.task;

import java.math.BigDecimal;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import com.ximai.mes.pro.domain.task.ProPackagePrintRecord;
import com.ximai.mes.pro.domain.task.ProTaskWorkunit;
import com.ximai.mes.pro.domain.vo.ProPackagePrintRecordQuery;
import com.ximai.mes.pro.domain.vo.proWorkOrder.WorkorderPackagePrint;
import com.ximai.mes.pro.domain.vo.task.BlPackagePrintParams;
import com.ximai.mes.pro.domain.vo.task.FeedbackPackageAddParams;
import com.ximai.mes.pro.domain.vo.task.RePackagePrintParams;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 报工包装标签打印记录表Service接口
 *
 * @author generator
 * @date 2024-03-19
 */
public interface IProPackagePrintRecordService
{

    public static String PL_PACK_CODE = "PL_PACK_CODE";
    public static String BL_PACK_CODE = "BL_PACK_CODE";
    public static String BL = "BL";
    public static String PL = "PL";
    /**
     * 超报工
     */
    public static String SL = "SL";
    /**
     * 查询报工包装标签打印记录表
     *
     * @param recordId 报工包装标签打印记录表主键
     * @return 报工包装标签打印记录表
     */
    public ProPackagePrintRecord selectProPackagePrintRecordByRecordId(Long recordId);

    /**
     * 查询报工包装标签打印记录表
     *
     * @param qrcode 二维码
     * @return 报工包装标签打印记录表
     */
    public ProPackagePrintRecord selectProPackagePrintRecordByQrcode(String qrcode);

    /**
     * 查询报工包装标签打印记录表
     *
     * @param barcode 二维码
     * @return 报工包装标签打印记录表
     */
    public ProPackagePrintRecord selectProPackagePrintRecordByBarcode(String barcode);

    /**
     * 查询报工包装标签打印记录表列表
     *
     * @param proFdPackagePrintRecord 报工包装标签打印记录表
     * @return 报工包装标签打印记录表集合
     */
    public List<ProPackagePrintRecord> selectProPackagePrintRecordList(ProPackagePrintRecordQuery proFdPackagePrintRecord);

    /**
     * 查询报工包装标签打印记录表列表
     *
     * @param query 报工包装标签打印记录表
     * @return 报工包装标签打印记录表集合
     */
    public List<ProPackagePrintRecord> selectProPackagePrintRecordList(QueryWrapper<ProPackagePrintRecord> query);

    /**
     * 新增报工包装标签打印记录表
     *
     * @param proFdPackagePrintRecord 报工包装标签打印记录表
     * @return 结果
     */
    public int insertProPackagePrintRecord(ProPackagePrintRecord proFdPackagePrintRecord);

    /**
     * 通过报工操作添加装箱标签
     */
    public ProPackagePrintRecord insertProPackagePrintRecordByFeedback(ProTaskWorkunit taskWorkunit, ProWorkorder workorder,
                                                                       FeedbackPackageAddParams feedbackAddParams, Integer allReportNum, BigDecimal netWeight);

    /**
     * 修改报工包装标签打印记录表
     *
     * @param proFdPackagePrintRecord 报工包装标签打印记录表
     * @return 结果
     */
    public int updateProPackagePrintRecord(ProPackagePrintRecord proFdPackagePrintRecord);

    /**
     * 批量删除报工包装标签打印记录表
     *
     * @param recordIds 需要删除的报工包装标签打印记录表主键集合
     * @return 结果
     */
    public int deleteProPackagePrintRecordByRecordIds(Long[] recordIds);

    /**
     * 删除报工包装标签打印记录表信息
     *
     * @param recordId 报工包装标签打印记录表主键
     * @return 结果
     */
    public int deleteProPackagePrintRecordByRecordId(Long recordId);

    /**
     * 查询报工包装标签条数
     * @param query
     * @return
     */
    public int count(QueryWrapper<ProPackagePrintRecord> query);

    /**
     * 批量修改净重、备注
     * @param list
     * @return
     */
    public void batchUpdate(@RequestBody List<ProPackagePrintRecord> list);

    /**
     * 记录打印次数并返回打印数据
     * @param workorderId
     * @param packageRecordList
     * @return
     */
    public List<WorkorderPackagePrint> recordPackagePrintInfo(Long workorderId, List<ProPackagePrintRecord> packageRecordList);

    /**
     * 返回打印标签信息，如果包装标签后面是装箱标签一并返回
     * @param qrcode 二维码
     * @return
     */
    public List<WorkorderPackagePrint> getPackagePrintInfo(ProPackagePrintRecord packagePrintRecord, Long orderId, boolean mergePack);

    /**
     * 打印次数更新
     * @param query
     * @return
     */
    public void printTimeAccumulation(QueryWrapper<ProPackagePrintRecord> query);

    /**
     * 包装工序补打标签数据
     *
     * @param query
     * @return
     */
    List<WorkorderPackagePrint> rePackageInfoPrint(RePackagePrintParams query);

    /**
     * 装箱标签打印并新增
     *
     * @param query
     * @return
     */
    List<WorkorderPackagePrint> blPackageInfoPrintOrInsert(BlPackagePrintParams query);


}
