package com.ximai.mes.pro.service.productionMake;

import java.util.List;
import com.ximai.mes.pro.domain.productionMake.ProProductionMake;
import com.ximai.mes.pro.domain.vo.ProProductionMakeVo;

/**
 * 量产制作Service接口
 *
 * @author chicheng.li
 * @date 2024-01-23
 */
public interface IProProductionMakeService
{
    /**
     * 查询量产制作
     *
     * @param productionMakeId 量产制作主键
     * @return 量产制作
     */
    public ProProductionMakeVo selectProProductionMakeByProductionMakeId(Long productionMakeId);

    /**
     * 查询量产制作列表
     *
     * @param proProductionMake 量产制作
     * @return 量产制作集合
     */
    public List<ProProductionMakeVo> selectProProductionMakeList(ProProductionMake proProductionMake);

    /**
     * 新增量产制作
     *
     * @param proProductionMakeVo 量产制作
     * @return 结果
     */
    public int insertProProductionMake(ProProductionMakeVo proProductionMakeVo);

    /**
     * 修改量产制作
     *
     * @param proProductionMakeVo 量产制作
     * @return 结果
     */
    public int updateProProductionMake(ProProductionMakeVo proProductionMakeVo);

    /**
     * 批量删除量产制作
     *
     * @param productionMakeIds 需要删除的量产制作主键集合
     * @return 结果
     */
    public int deleteProProductionMakeByProductionMakeIds(Long[] productionMakeIds);

    /**
     * 删除量产制作信息
     *
     * @param productionMakeId 量产制作主键
     * @return 结果
     */
    public int deleteProProductionMakeByProductionMakeId(Long productionMakeId);

    /**
     * 状态修改
     */
    public int updateProProductionMakeStatus(ProProductionMake proProductionMake);

    /**
     * 开始制作
     */
    public void beginMake(ProProductionMake proProductionMake);
}
