package com.ximai.mes.pro.service.proWorkOrder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.constant.WorkorderStatusEnum;
import com.ximai.mes.pro.domain.ep.EPDtoProWorkOrder;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import com.ximai.mes.pro.domain.sap.SAPDtoProWorkOrder;
import com.ximai.mes.pro.domain.vo.ProWorkOrderProcessToolLoseVo;
import com.ximai.mes.pro.domain.vo.ProWorkorderQuery;
import com.ximai.mes.pro.domain.vo.ProWorkorderVo;
import com.ximai.mes.pro.domain.vo.proWorkOrder.*;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @date 2022-05-09 * 生产工单Service接口
 */
public interface IProWorkorderService {

    /**
     * 查询生产工单
     *
     * @param workorderId 生产工单主键
     * @return 生产工单
     */
    ProWorkorderVo selectProWorkorderByWorkorderId(Long workorderId);

    /**
     * 单独查询工单任务
     *
     * @param workorderId
     * @return
     */
    ProWorkorder selectWorkorderById(Long workorderId);

    /**
     * 查询生产工单
     *
     * @param workorderCode 生产工单主键
     * @return 生产工单
     */
    List<ProWorkorder> selectArrangeListByCode(String workorderCode);

    /**
     * 查询生产工单列表
     *
     * @param proWorkorder 生产工单
     * @return 生产工单集合
     */
    List<ProWorkorder> selectProWorkorderList(ProWorkorderQuery proWorkorder);

    /**
     * 查询生产工单列表
     *
     * @param query 生产工单
     * @return 生产工单集合
     */
    List<ProWorkorder> selectListByQw(QueryWrapper<ProWorkorder> query);

    /**
     * 查询生产工单列表
     *
     * @param proWorkorder 根据中间表pro_task_workorder查询task_id生产工单列表
     * @return 生产工单集合
     */
    List<ProWorkorder> selectProWorkorderByTaskId(ProWorkorder proWorkorder);


    boolean checkWorkorderIsExsit(ProWorkorder proWorkorder);

    /**
     * 新增生产工单
     *
     * @param proWorkorder 生产工单
     * @return 结果
     */
    int insertProWorkorder(ProWorkorder proWorkorder);

    /**
     * 新增生产工单（包含bom及工序）
     *
     * @param proWorkorderVo 生产工单
     * @return 结果
     */
    int insertProWorkorderVo(ProWorkorderVo proWorkorderVo);

    /**
     * 修改生产工单
     *
     * @param proWorkorder 生产工单
     * @return 结果
     */
    int updateProWorkorder(ProWorkorder proWorkorder);

    /**
     * 修改生产工单
     *
     * @param proWorkorder 生产工单
     * @return 结果
     */
    int updateWoStatusByArrangeCode(ProWorkorder proWorkorder);

    /**
     * 批量删除生产工单
     *
     * @param workorderIds 需要删除的生产工单主键集合
     * @return 结果
     */
    int deleteProWorkorderByWorkorderIds(Long[] workorderIds);

    /**
     * 删除生产工单信息
     *
     * @param workorderId 生产工单主键
     * @return 结果
     */
    int deleteProWorkorderByWorkorderId(Long workorderId);


    /**
     * 修改生产工单（附带bom，工序）
     *
     * @param proWorkorderVo 生产工单
     * @return 结果
     */
    int updateProWorkorderWithBomAndProcess(ProWorkorderVo proWorkorderVo);

    /**
     * 修改生产工单方法
     *
     * @param workorderId 生产工单主键   status 工单状态
     * @return 生产工单
     */
    void updateProWorkorderStatus(List<Long> workorderId, WorkorderStatusEnum workOrderStatusEnum);


    /**
     * 工单工装齐套检查
     *
     * @param workOrderIds 工单ID
     */
    List<ProWorkOrderProcessToolLoseVo> checkToolNum(Long[] workOrderIds);


    String importWorkOrder(MultipartFile file) throws Exception;

    void importTemplate(HttpServletResponse response) throws IOException;

    void generateBomLine(Long workorderId);

    Integer countByParentCode(String workorderCode);

    void addComplements(ProWorkorderVo proWorkorder);

    /**
     * 按工单生成所有包装标签生成
     */
    void buildAllPackagePrintInfo(BuildPackageParams2 buildPackageParams2);

    /**
     * 按工单、SIZE、指令生成包装标签
     *
     * @param buildPackageParams
     * @return
     */
    WorkorderPackageResult buildPackagePrintInfo(BuildPackageParams2 buildPackageParams);

    /**
     * 按SZIE、指令的拆分数据重组数据
     *
     * @param packageList
     * @return
     */
    List<WorkorderPackage> convertSplitData(List<WorkorderPackage> packageList);

    ProWorkorder insertObj(ProWorkorder proWorkorderVo, ProWorkorderVo workorderVo);

    @Transactional
    int clossAndDeleteObjV2(ProWorkorder workorder);

    int closeObj(ProWorkorder workorderCode);

    List<ProWorkorder> selectSaleAndWorkorderList(ProWorkorder proWorkorder);

    List<Map<String, String>> getWorkorderProcessInfo(String workorderCode);

    List<ProWorkorderPrintTab> selectWorkorderPrintTab(ProWorkorderQuery proWorkorder);

    /**
     * 打样生产工单任务生成
     *
     * @param workorderProofMakeProduction
     */
    void proofMakeProduction(WorkorderProofMakeProduction workorderProofMakeProduction);

    List<ProWorkorderVo> getFeedBackRecord(ProWorkorderQuery proWorkorder);

    Map<Object, Object> quantityWaitSum(Map<String, String> body);

    int updateObject(ProWorkorderVo proWorkorderVo);

}
