package com.ximai.mes.pro.service.impl.productionSolution;

import java.util.List;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.pro.mapper.productionSolution.ProProductionSolutionProcessDrawingMapper;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcessDrawing;
import com.ximai.mes.pro.dto.productionSolution.ProProductionSolutionProcessDrawingCreate;
import com.ximai.mes.pro.dto.productionSolution.ProProductionSolutionProcessDrawingUpdate;
import com.ximai.mes.pro.dto.productionSolution.ProProductionSolutionProcessDrawingDto;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionProcessDrawingService;

/**
 * 生产版本工序图纸Service业务层处理
 *
 * @author generator
 * @date 2024-08-29
 */
@Service
public class ProProductionSolutionProcessDrawingServiceImpl implements IProProductionSolutionProcessDrawingService
{
    @Autowired
    private ProProductionSolutionProcessDrawingMapper proProductionSolutionProcessDrawingMapper;

    /**
     * 查询生产版本工序图纸
     *
     * @param productionSolutionProcessFileId 生产版本工序图纸主键
     * @return 生产版本工序图纸
     */
    @Override
    public ProProductionSolutionProcessDrawingDto selectProProductionSolutionProcessDrawingDtoByProductionSolutionProcessFileId(Long productionSolutionProcessFileId)
    {
        return proProductionSolutionProcessDrawingMapper.selectProProductionSolutionProcessDrawingByProductionSolutionProcessFileId(productionSolutionProcessFileId);
    }

    /**
     * 查询生产版本工序图纸
     *
     * @param productionSolutionProcessFileId 生产版本工序图纸主键
     * @return 生产版本工序图纸
     */
    @Override
    public ProProductionSolutionProcessDrawing selectProProductionSolutionProcessDrawingByProductionSolutionProcessFileId(Long productionSolutionProcessFileId)
    {
        return proProductionSolutionProcessDrawingMapper.selectById(productionSolutionProcessFileId);
    }

    /**
     * 查询生产版本工序图纸列表
     *
     * @param proProductionSolutionProcessDrawing 生产版本工序图纸
     * @return 生产版本工序图纸
     */
    @Override
    public List<ProProductionSolutionProcessDrawingDto> selectProProductionSolutionProcessDrawingList(ProProductionSolutionProcessDrawing proProductionSolutionProcessDrawing)
    {
        return proProductionSolutionProcessDrawingMapper.selectProProductionSolutionProcessDrawingList(proProductionSolutionProcessDrawing);
    }

    /**
     * 查询生产版本工序图纸列表
     *
     * @param proProductionSolutionProcessDrawingQuery 生产版本工序图纸
     * @return 生产版本工序图纸
     */
    @Override
    public List<ProProductionSolutionProcessDrawing> selectProProductionSolutionProcessDrawingList(QueryWrapper<ProProductionSolutionProcessDrawing> proProductionSolutionProcessDrawingQuery)
    {
        return proProductionSolutionProcessDrawingMapper.selectList(proProductionSolutionProcessDrawingQuery);
    }

    /**
     * 新增生产版本工序图纸
     *
     * @param proProductionSolutionProcessDrawingCreate 生产版本工序图纸
     * @return 结果
     */
    @Override
    public int insertProProductionSolutionProcessDrawing(ProProductionSolutionProcessDrawingCreate proProductionSolutionProcessDrawingCreate)
    {
        ProProductionSolutionProcessDrawing proProductionSolutionProcessDrawing = new ProProductionSolutionProcessDrawing();
        BeanUtil.copyProperties(proProductionSolutionProcessDrawingCreate, proProductionSolutionProcessDrawing);
        return proProductionSolutionProcessDrawingMapper.insertProProductionSolutionProcessDrawing(proProductionSolutionProcessDrawing);
    }

    /**
     * 修改生产版本工序图纸
     *
     * @param proProductionSolutionProcessDrawingUpdate 生产版本工序图纸
     * @return 结果
     */
    @Override
    public int updateProProductionSolutionProcessDrawing(ProProductionSolutionProcessDrawingUpdate proProductionSolutionProcessDrawingUpdate)
    {
        ProProductionSolutionProcessDrawing proProductionSolutionProcessDrawing = new ProProductionSolutionProcessDrawing();
        BeanUtil.copyProperties(proProductionSolutionProcessDrawingUpdate, proProductionSolutionProcessDrawing);
        return proProductionSolutionProcessDrawingMapper.updateProProductionSolutionProcessDrawing(proProductionSolutionProcessDrawing);
    }

    /**
     * 批量删除生产版本工序图纸
     *
     * @param productionSolutionProcessFileIds 需要删除的生产版本工序图纸主键
     * @return 结果
     */
    @Override
    public int deleteProProductionSolutionProcessDrawingByProductionSolutionProcessFileIds(Long[] productionSolutionProcessFileIds)
    {
        return proProductionSolutionProcessDrawingMapper.deleteProProductionSolutionProcessDrawingByProductionSolutionProcessFileIds(productionSolutionProcessFileIds);
    }

    /**
     * 删除生产版本工序图纸信息
     *
     * @param productionSolutionProcessFileId 生产版本工序图纸主键
     * @return 结果
     */
    @Override
    public int deleteProProductionSolutionProcessDrawingByProductionSolutionProcessFileId(Long productionSolutionProcessFileId)
    {
        return proProductionSolutionProcessDrawingMapper.deleteProProductionSolutionProcessDrawingByProductionSolutionProcessFileId(productionSolutionProcessFileId);
    }
}
