package com.ximai.mes.pro.service.impl.productionRequest;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.productionRequest.ProProductionRequestProcessItemMapper;
import com.ximai.mes.pro.domain.productionRequest.ProProductionRequestProcessItem;
import com.ximai.mes.pro.service.productionRequest.IProProductionRequestProcessItemService;

/**
 * 量产申请工序物料Service业务层处理
 *
 * @author chicheng.li
 * @date 2024-01-22
 */
@Service
public class ProProductionRequestProcessItemServiceImpl implements IProProductionRequestProcessItemService
{
    @Autowired
    private ProProductionRequestProcessItemMapper proProductionRequestProcessItemMapper;

    /**
     * 查询量产申请工序物料
     *
     * @param productionRequestProcessItemId 量产申请工序物料主键
     * @return 量产申请工序物料
     */
    @Override
    public ProProductionRequestProcessItem selectProProductionRequestProcessItemByProductionRequestProcessItemId(Long productionRequestProcessItemId)
    {
        return proProductionRequestProcessItemMapper.selectProProductionRequestProcessItemByProductionRequestProcessItemId(productionRequestProcessItemId);
    }

    /**
     * 查询量产申请工序物料列表
     *
     * @param proProductionRequestProcessItem 量产申请工序物料
     * @return 量产申请工序物料
     */
    @Override
    public List<ProProductionRequestProcessItem> selectProProductionRequestProcessItemList(ProProductionRequestProcessItem proProductionRequestProcessItem)
    {
        return proProductionRequestProcessItemMapper.selectProProductionRequestProcessItemList(proProductionRequestProcessItem);
    }

    /**
     * 新增量产申请工序物料
     *
     * @param proProductionRequestProcessItem 量产申请工序物料
     * @return 结果
     */
    @Override
    public int insertProProductionRequestProcessItem(ProProductionRequestProcessItem proProductionRequestProcessItem)
    {
        return proProductionRequestProcessItemMapper.insertProProductionRequestProcessItem(proProductionRequestProcessItem);
    }

    /**
     * 修改量产申请工序物料
     *
     * @param proProductionRequestProcessItem 量产申请工序物料
     * @return 结果
     */
    @Override
    public int updateProProductionRequestProcessItem(ProProductionRequestProcessItem proProductionRequestProcessItem)
    {
        return proProductionRequestProcessItemMapper.updateProProductionRequestProcessItem(proProductionRequestProcessItem);
    }

    /**
     * 批量删除量产申请工序物料
     *
     * @param productionRequestProcessItemIds 需要删除的量产申请工序物料主键
     * @return 结果
     */
    @Override
    public int deleteProProductionRequestProcessItemByProductionRequestProcessItemIds(Long[] productionRequestProcessItemIds)
    {
        return proProductionRequestProcessItemMapper.deleteProProductionRequestProcessItemByProductionRequestProcessItemIds(productionRequestProcessItemIds);
    }

    /**
     * 删除量产申请工序物料信息
     *
     * @param productionRequestProcessItemId 量产申请工序物料主键
     * @return 结果
     */
    @Override
    public int deleteProProductionRequestProcessItemByProductionRequestProcessItemId(Long productionRequestProcessItemId)
    {
        return proProductionRequestProcessItemMapper.deleteProProductionRequestProcessItemByProductionRequestProcessItemId(productionRequestProcessItemId);
    }
}
