package com.ximai.mes.pro.service.impl.proWorkOrder;

import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderDtaRecord;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkOrderDtaRecordMapper;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderDtaRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * dto排版记录Service业务层处理
 *
 * @author generator
 * @date 2024-05-18
 */
@Service
public class ProWorkOrderDtaRecordServiceImpl implements IProWorkOrderDtaRecordService {
    @Autowired
    private ProWorkOrderDtaRecordMapper proWorkOrderDtaRecordMapper;

    /**
     * 查询dto排版记录
     *
     * @param id dto排版记录主键
     * @return dto排版记录
     */
    @Override
    public ProWorkOrderDtaRecord selectProWorkOrderDtoRecordById(Long id) {
        return proWorkOrderDtaRecordMapper.selectProWorkOrderDtaRecordById(id);
    }

    /**
     * 查询dto排版记录列表
     *
     * @param proWorkOrderDtaRecord dto排版记录
     * @return dto排版记录
     */
    @Override
    public List<ProWorkOrderDtaRecord> selectProWorkOrderDtoRecordList(ProWorkOrderDtaRecord proWorkOrderDtaRecord) {
        return proWorkOrderDtaRecordMapper.selectProWorkOrderDtaRecordList(proWorkOrderDtaRecord);
    }

    /**
     * 新增dto排版记录
     *
     * @param proWorkOrderDtaRecord dto排版记录
     * @return 结果
     */
    @Override
    public int insertProWorkOrderDtoRecord(ProWorkOrderDtaRecord proWorkOrderDtaRecord) {
        proWorkOrderDtaRecord.createAction();
        return proWorkOrderDtaRecordMapper.insertProWorkOrderDtaRecord(proWorkOrderDtaRecord);
    }

    /**
     * 修改dto排版记录
     *
     * @param proWorkOrderDtaRecord dto排版记录
     * @return 结果
     */
    @Override
    public int updateProWorkOrderDtoRecord(ProWorkOrderDtaRecord proWorkOrderDtaRecord) {
        proWorkOrderDtaRecord.updateAction();
        return proWorkOrderDtaRecordMapper.updateProWorkOrderDtaRecord(proWorkOrderDtaRecord);
    }

    /**
     * 批量删除dto排版记录
     *
     * @param ids 需要删除的dto排版记录主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderDtoRecordByIds(Long[] ids) {
        return proWorkOrderDtaRecordMapper.deleteProWorkOrderDtaRecordByIds(ids);
    }

    /**
     * 删除dto排版记录信息
     *
     * @param id dto排版记录主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderDtoRecordById(Long id) {
        return proWorkOrderDtaRecordMapper.deleteProWorkOrderDtaRecordById(id);
    }

    @Override
    public int confirm(Long id) {
        ProWorkOrderDtaRecord proWorkOrderDtaRecord = this.selectProWorkOrderDtoRecordById(id);
        ExceptionUtil.checkTrueThrowException(proWorkOrderDtaRecord.getEndTime() != null, "已经完成,不可重复确认");
        proWorkOrderDtaRecord.setEndTime(new Date());
        return proWorkOrderDtaRecordMapper.updateProWorkOrderDtaRecord(proWorkOrderDtaRecord);
    }
}
