package com.ximai.mes.pro.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.ximai.common.constant.UserConstants;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.pro.domain.ProProcess;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcess;
import com.ximai.mes.pro.domain.vo.ProProcessVo;
import com.ximai.mes.pro.domain.vo.ProProductionSolutionProcessVo;
import com.ximai.mes.pro.mapper.ProProcessMapper;
import com.ximai.mes.pro.service.IProProcessService;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * 生产工序Service业务层处理
 *
 * @date 2022-05-11
 */
@Service
public class ProProcessServiceImpl implements IProProcessService {
    @Autowired
    private ProProcessMapper proProcessMapper;

    @Autowired
    private IProProductionSolutionProcessService proProductionSolutionProcessService;

    /**
     * 查询生产工序
     *
     * @param processId 生产工序主键
     * @return 生产工序
     */
    @Override
    public ProProcess selectProProcessByProcessId(Long processId) {
        return proProcessMapper.selectProProcessByProcessId(processId);
    }

    /**
     * 查询生产工序列表
     *
     * @param proProcess 生产工序
     * @return 生产工序
     */
    @Override
    public List<ProProcess> selectProProcessList(ProProcess proProcess) {
        return proProcessMapper.selectProProcessList(proProcess);
    }

    /**
     * 检查工序编码是否唯一
     *
     * @param proProcess
     * @return
     */
    @Override
    public String checkProcessCodeUnique(ProProcess proProcess) {
        ProProcess process = proProcessMapper.checkProcessCodeUnique(proProcess);
        Long processId = proProcess.getProcessId() == null ? -1L : proProcess.getProcessId();
        if (StringUtils.isNotNull(process) && process.getProcessId().longValue() != processId.longValue()) {
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }


    /**
     * 检查工序名称是否唯一
     *
     * @param proProcess
     * @return
     */
    @Override
    public String checkProcessNameUnique(ProProcess proProcess) {
        ProProcess process = proProcessMapper.checkProcessNameUnique(proProcess);
        Long processId = proProcess.getProcessId() == null ? -1L : proProcess.getProcessId();
        if (StringUtils.isNotNull(process) && process.getProcessId().longValue() != processId.longValue()) {
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    /**
     * 新增生产工序
     *
     * @param proProcess 生产工序
     * @return 结果
     */
    @Override
    public int insertProProcess(ProProcess proProcess) {
        proProcess.setCreateTime(DateUtils.getNowDate());
        return proProcessMapper.insertProProcess(proProcess);
    }

    /**
     * 修改生产工序
     *
     * @param proProcess 生产工序
     * @return 结果
     */
    @Override
    public int updateProProcess(ProProcess proProcess) {
        proProcess.setUpdateTime(DateUtils.getNowDate());
        return proProcessMapper.updateProProcess(proProcess);
    }

    /**
     * 批量删除生产工序
     *
     * @param processIds 需要删除的生产工序主键
     * @return 结果
     */
    @Override
    public int deleteProProcessByProcessIds(Long[] processIds) {
        return proProcessMapper.deleteProProcessByProcessIds(processIds);
    }

    /**
     * 删除生产工序信息
     *
     * @param processId 生产工序主键
     * @return 结果
     */
    @Override
    public int deleteProProcessByProcessId(Long processId) {
        return proProcessMapper.deleteProProcessByProcessId(processId);
    }

    @Override
    public int processCreate(ProProcessVo proProcessVo) {
        ProProcess proProcessEp = proProcessVo.deepCopyObj(ProProcess.class);

        if (proProcessVo.getUpdateLog() == 'I') {
            ProProcess proProcess = proProcessMapper.selectProProcessByProcessCodes(proProcessEp.getProcessCode());
            ProProcess proProcess1 = proProcessMapper.selectProProcessByProcessName(proProcessEp.getProcessName());
            ExceptionUtil.checkTrueThrowException(Objects.nonNull(proProcess), "数据编码已经存在，不能重复添加！");
            ExceptionUtil.checkTrueThrowException(Objects.nonNull(proProcess1), "数据名称已经存在，不能重复添加！");
            insertProProcess(proProcessEp);
            return 1;
        } else if (proProcessVo.getUpdateLog() == 'D') {
            ProProcess proProcess = proProcessMapper.selectProProcessByProcessCodes(proProcessEp.getProcessCode());
            if(proProcess.getEnableFlag().equals("N")){
                ExceptionUtil.checkTrueThrowException(true, "该数据已被关闭!");
            }
            ProProductionSolutionProcess proProductionSolutionProcess = new ProProductionSolutionProcess();
            proProductionSolutionProcess.setProcessId(proProcess.getProcessId());
            List<ProProductionSolutionProcessVo> proProductionSolutionProcesses = proProductionSolutionProcessService.selectProProductionSolutionProcessList(proProductionSolutionProcess);
            ExceptionUtil.checkTrueThrowException(CollectionUtil.isNotEmpty(proProductionSolutionProcesses), "该数据被使用不能关闭!");
            proProcessEp.setProcessId(proProcess.getProcessId());
            updateProProcess(proProcessEp);
            return 3;
        } else {
            ProProcess proProcess = proProcessMapper.selectProProcessByProcessCodes(proProcessEp.getProcessCode());
            ProProcess proProcess1 = proProcessMapper.selectProProcessByProcessName(proProcessEp.getProcessName());
            if(Objects.nonNull(proProcess1)){
                ExceptionUtil.checkTrueThrowException(!proProcess.getProcessId().equals(proProcess1.getProcessId()), "数据修改的名称已经存在！");
            }
            proProcessEp.setProcessId(proProcess.getProcessId());
            updateProProcess(proProcessEp);
            return 2;
        }


    }
}
