package com.ximai.mes.pro.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.constant.UserConstants;
import com.ximai.common.exception.ServiceException;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.constant.MaterialTypeEnum;
import com.ximai.mes.md.domain.MdItem;
import com.ximai.mes.md.domain.MdWorkstation;
import com.ximai.mes.md.domain.MdWorkunit;
import com.ximai.mes.md.mapper.MdItemMapper;
import com.ximai.mes.md.mapper.MdWorkstationMapper;
import com.ximai.mes.md.mapper.MdWorkunitMapper;
import com.ximai.mes.md.vo.MdWorkunitVo;
import com.ximai.mes.pro.domain.ProAllocationMaterial;
import com.ximai.mes.pro.domain.ProMaterialRequest;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcess;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcessItem;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.pro.domain.task.ProTaskWorkorder;
import com.ximai.mes.pro.domain.task.ProTaskWorkunit;
import com.ximai.mes.pro.domain.vo.*;
import com.ximai.mes.pro.domain.vo.task.MaterialRequestIds;
import com.ximai.mes.pro.mapper.ProMaterialRequestMapper;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkOrderProcessItemMapper;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkOrderProcessMapper;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkorderMapper;
import com.ximai.mes.pro.mapper.task.ProTaskMapper;
import com.ximai.mes.pro.mapper.task.ProTaskWorkorderMapper;
import com.ximai.mes.pro.mapper.task.ProTaskWorkunitMapper;
import com.ximai.mes.pro.service.IProAllocationMaterialService;
import com.ximai.mes.pro.service.IProMaterialRequestService;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderProcessItemService;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderProcessService;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkorderService;
import com.ximai.mes.pro.service.task.IProTaskWorkunitService;
import com.ximai.mes.wm.domain.WmIssueLine;
import com.ximai.mes.wm.domain.tx.WmIssueLineJoinBean;
import com.ximai.mes.wm.domain.vo.WmIssueVo;
import com.ximai.mes.wm.service.IWmIssueLineService;
import com.ximai.system.strategy.AutoCodeUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * 领料申请Service业务层处理
 *
 * @author generator
 * @date 2024-02-22
 */
@Service
public class ProMaterialRequestServiceImpl implements IProMaterialRequestService {
    @Autowired
    private ProMaterialRequestMapper proMaterialRequestMapper;
    @Autowired
    private AutoCodeUtil autoCodeUtil;
    @Autowired
    private IWmIssueLineService wmIssueLineService;
    @Autowired
    private ProTaskWorkorderMapper proTaskWorkorderMapper;

    @Autowired
    private IProWorkorderService proWorkorderService;

    @Autowired
    private ProWorkorderMapper proWorkorderMapper;

    @Autowired
    private IProWorkOrderProcessService proWorkOrderProcessService;

    @Autowired
    private IProWorkOrderProcessItemService proWorkOrderProcessItemService;

    @Autowired
    private MdItemMapper mdItemMapper;

    @Autowired
    private IProTaskWorkunitService proTaskWorkunitService;

    @Autowired
    private MdWorkunitMapper mdWorkunitMapper;

    @Autowired
    private ProTaskMapper proTaskMapper;

    @Autowired
    private IProAllocationMaterialService proAllocationMaterialService;

    @Autowired
    private ProWorkOrderProcessMapper proWorkOrderProcessMapper;

    @Autowired
    private ProWorkOrderProcessItemMapper proWorkOrderProcessItemMapper;

    @Autowired
    private IProMaterialRequestService proMaterialRequestService;

    @Autowired
    private MdWorkstationMapper mdWorkstationMapper;

    @Autowired
    private ProTaskWorkunitMapper proTaskWorkunitMapper;


    /**
     * 查询领料申请
     *
     * @param materialRequestId 领料申请主键
     * @return 领料申请
     */
    @Override
    public ProMaterialRequest selectProMaterialRequestByMaterialRequestId(Long materialRequestId) {
        return proMaterialRequestMapper.selectProMaterialRequestByMaterialRequestId(materialRequestId);
    }

    /**
     * 领用申请查看生产工单物料
     *
     * @param proMaterialRequestVo
     * @return
     */
    @Override
    public List<ProMaterialRequestItemVo> selectProMaterialRequestByMaterialRequestWorkorderId(ProMaterialRequestVo proMaterialRequestVo) {
        List<ProMaterialRequestItemVo> MaterialRequest = new ArrayList<>();

        ProWorkorderVo proWorkorderVo = proWorkorderService.selectProWorkorderByWorkorderId(proMaterialRequestVo.getWorkorderId());
        if (Objects.isNull(proWorkorderVo)) {
            return null;
        }
        List<ProWorkOrderProcessVo> processList = proWorkorderVo.getProcessList();
        if (CollUtil.isEmpty(processList)) {
            return null;
        }
        for (ProWorkOrderProcessVo pr : processList) {
            if (proMaterialRequestVo.getProcessId().equals(pr.getProcessId())) {
                if (Objects.nonNull(pr.getProcessItemList())) {
                    for (ProWorkOrderProcessItem proWorkOrderProcessItem : pr.getProcessItemList()) {
                        ProMaterialRequestItemVo proMaterialRequest = new ProMaterialRequestItemVo();
                        proMaterialRequest.setItemId(proWorkOrderProcessItem.getItemId());
                        proMaterialRequest.setItemName(proWorkOrderProcessItem.getItemName());
                        QueryWrapper<MdItem> queryWrapper = new QueryWrapper<>();
                        queryWrapper.eq("item_id", proWorkOrderProcessItem.getItemId());
                        List<MdItem> mdItems = mdItemMapper.selectListByQw(queryWrapper);
                        MdItem mdItem = mdItems.get(0);
                        proMaterialRequest.setItemCode(mdItem.getItemCode());
                        proMaterialRequest.setUnitOfMeasure(proWorkOrderProcessItem.getUnitOfMeasure());
                        proMaterialRequest.setIsBackflush(proWorkOrderProcessItem.getIsBackflush());
                        MaterialRequest.add(proMaterialRequest);

                    }

                }
            }
        }
        return MaterialRequest;
    }

    /**
     * 查询领料申请列表
     *
     * @param proMaterialRequest 领料申请
     * @return 领料申请
     */
    @Override
    public List<ProMaterialRequest> selectProMaterialRequestList(ProMaterialRequest proMaterialRequest) {
        return proMaterialRequestMapper.selectProMaterialRequestList(proMaterialRequest);
    }

    @Override
    public List<ProMaterialRequestVo> selectListVo(QueryWrapper<ProMaterialRequest> query) {
        return proMaterialRequestMapper.selectListByQw(query);
    }

    @Override
    public List<ProMaterialRequest> selectList(QueryWrapper<ProMaterialRequest> query) {
        return proMaterialRequestMapper.selectListByQw2(query);
    }

    /**
     * 新增领料申请
     *
     * @param proMaterialRequest 领料申请
     * @return 结果
     */
    @Override
    public int insertProMaterialRequest(ProMaterialRequest proMaterialRequest) {
        proMaterialRequest.createAction();
        if (StringUtils.isNotNull(proMaterialRequest.getPickingReason())) {
            proMaterialRequest.setMaterialType(1L);
            proMaterialRequest.setStartTime(DateUtils.getNowDate());
            proMaterialRequest.setWindCase("N");
        } else {
            proMaterialRequest.setMaterialType(0L);
            proMaterialRequest.setWindCase("N");
        }

        return proMaterialRequestMapper.insertProMaterialRequest(proMaterialRequest);
    }

    /**
     * pad生产的领料单
     *
     * @param appendList
     */
    @Override
    @Transactional
    public void insertProMaterialRequest(List<ProMaterialRequest> appendList) {
        String tempCode = autoCodeUtil.genSerialCode(UserConstants.MATERIAL_REQUEST_CODE, "");
        //调拨料单编码自动生成
        String s1 = autoCodeUtil.genSerialCode(UserConstants.ALLOCATION_CODE, "");
        for (ProMaterialRequest append : appendList) {
            MdWorkunit mdWorkunit = mdWorkunitMapper.selectMdWorkunitByWorkunitCodes(append.getWorkunitCode());
            ProTaskWorkunit proTaskWorkunit = proTaskWorkunitMapper.selectProTaskWorkunitByTaskWorkunitId(append.getTaskWorkunitId());
            if (!append.getIsBackflush().equals(MaterialTypeEnum.BACKFLUSH.getValue())) {

                List<ProMaterialRequestItemVo2> material = new ArrayList<>();
                //判断工单id是否为空
                if (StringUtils.isEmpty(append.getWorkorderCode())) {
                    //获取所有工单下相同工序和相同物料的收集
                    material = itemDistribution(append, material);
                    //是否只有一个工单有相同物料
                    if (material.size() == 1) {

                        for (ProMaterialRequestItemVo2 ma : material) {
                            //判断数量是否大于任务所需要的数量
                            ProTask proTask = proTaskMapper.selectProTaskByTaskId(append.getTaskId());
                            QueryWrapper<ProWorkOrderProcess> queryWrapper = new QueryWrapper<>();
                            queryWrapper.eq("ss.workorder_code", ma.getWorkorderCode());
                            queryWrapper.eq("ss.process_id", proTask.getProcessId());
                            queryWrapper.eq("it.item_id", append.getItemId());
                            ProWorkOrderProcessItem processItem = proWorkOrderProcessItemMapper.selectProWordorderAndProcess(queryWrapper);
                            ProMaterialRequest proMaterialRequest1 = new ProMaterialRequest();
                            proMaterialRequest1.setTaskId(ma.getTaskId());
                            proMaterialRequest1.setWorkorderCode(ma.getWorkorderCode());
                            List<ProMaterialRequest> proMaterialRequests = proMaterialRequestService.selectProMaterialRequestList(proMaterialRequest1);
                            List<ProMaterialRequest> collect1 = proMaterialRequests.stream().filter(s -> s.getMaterialType() == 1).collect(Collectors.toList());
                            BigDecimal bigDecimal1 = BigDecimal.ZERO;
                            for (ProMaterialRequest proMaterialRequest : collect1) {
                                bigDecimal1 = bigDecimal1.add(proMaterialRequest.getApplyNum());
                            }
                            if (bigDecimal1.add(append.getApplyNum()).compareTo(processItem.getQuantity()) > 0) {
                                BigDecimal subtract = processItem.getQuantity().subtract(bigDecimal1);
                                throw new ServiceException("直发料申请数量超过"+subtract+"工单" + append.getWorkorderCode() + "的任务数量");
                            }


                            ma.setApplyNum(append.getApplyNum());
                            ProMaterialRequest proMaterialRequest = ma.deepCopyObj(ProMaterialRequest.class);
                            proMaterialRequest.setApplyNo(tempCode);
                            ProWorkOrderProcess proWorkOrderProcess = new ProWorkOrderProcess();
                            ProWorkorder proWorkorder = proWorkorderMapper.selectProWorkorderWorderCode(ma.getWorkorderCode());

                            if (!StringUtils.isNull(proWorkorder)) {
                                proWorkOrderProcess.setWorkorderId(proWorkorder.getWorkorderId());
                                List<ProWorkOrderProcessVo> proWorkOrderProcessVos = proWorkOrderProcessService.selectProWorkOrderProcessList(proWorkOrderProcess);
                                //根据任务单号查询工单关联的对应工序
                                for (ProWorkOrderProcessVo pro : proWorkOrderProcessVos) {
                                    if (Objects.equals(pro.getProcessId(), proTask.getProcessId())) {
                                        ProWorkOrderProcessItem proWorkOrderProcessItem = new ProWorkOrderProcessItem();
                                        proWorkOrderProcessItem.setWorkorderProcessId(pro.getWorkorderProcessId());
                                        List<ProWorkOrderProcessItem> processItemList = proWorkOrderProcessItemService.selectProWorkOrderProcessItemList(proWorkOrderProcessItem);
                                        if (CollectionUtil.isNotEmpty(processItemList)) {
                                            for (ProWorkOrderProcessItem item : processItemList) {
                                                if (Objects.equals(item.getItemId(), append.getItemId())) {
                                                    proMaterialRequest.setRequirementNumber(item.getRequirementNumber());
                                                    proMaterialRequest.setRequirementProjectNumber(item.getRequirementProjectNumber());
                                                }
                                            }
                                        }
                                    }

                                }
                            }
                            proMaterialRequest.setWorkunitId(mdWorkunit.getWorkunitId());
                            proMaterialRequest.setWorkstationCode(proTask.getWorkstationCode());
                            proMaterialRequest.setWorkstationName(proTask.getWorkstationName());
                            proMaterialRequest.setEndTime(proTaskWorkunit.getScheduleEndDate());
                            insertProMaterialRequest(proMaterialRequest);
                        }
                    } else {
                        //判断数量是否大于任务所需要的数量
                        BigDecimal reduce = material.stream()
                                .map(ProMaterialRequestItemVo2::getQuantity)
                                .reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal result = append.getApplyNum().divide(reduce, 5, RoundingMode.HALF_UP);
                        ProMaterialRequest proMaterialRequest1 = new ProMaterialRequest();
                        proMaterialRequest1.setTaskId(append.getTaskId());
                        List<ProMaterialRequest> proMaterialRequests = proMaterialRequestService.selectProMaterialRequestList(proMaterialRequest1);
                        List<ProMaterialRequest> collect1 = proMaterialRequests.stream().filter(s -> s.getMaterialType() == 1).collect(Collectors.toList());
                        BigDecimal bigDecimal1 = BigDecimal.ZERO;
                        for (ProMaterialRequest proMaterialRequest : collect1) {
                            bigDecimal1 = bigDecimal1.add(proMaterialRequest.getApplyNum());
                        }
                        if (bigDecimal1.add(append.getApplyNum()).compareTo(reduce) > 0) {
                            BigDecimal subtract = reduce.subtract(bigDecimal1);
                            throw new ServiceException("直发料申请数量不能超过"+subtract+"工单的任务数量");
                        }
                        for (ProMaterialRequestItemVo2 ma : material) {
                            ProTask proTask = proTaskMapper.selectProTaskByTaskId(append.getTaskId());
                            BigDecimal multiply = ma.getQuantity().multiply(result);
                            BigDecimal bigDecimal = multiply.setScale(3, RoundingMode.DOWN);
                            ma.setApplyNum(bigDecimal);
                            ProMaterialRequest proMaterialRequest = ma.deepCopyObj(ProMaterialRequest.class);
                            proMaterialRequest.setApplyNo(tempCode);
                            ProWorkorder proWorkorder = proWorkorderMapper.selectProWorkorderWorderCode(ma.getWorkorderCode());
                            if (!StringUtils.isNull(proWorkorder)) {
                                ProWorkOrderProcess proWorkOrderProcess = new ProWorkOrderProcess();
                                proWorkOrderProcess.setWorkorderId(proWorkorder.getWorkorderId());
                                List<ProWorkOrderProcessVo> proWorkOrderProcessVos = proWorkOrderProcessService.selectProWorkOrderProcessList(proWorkOrderProcess);
                                //根据任务单号查询工单关联的对应工序
                                for (ProWorkOrderProcessVo pro : proWorkOrderProcessVos) {
                                    if (Objects.equals(pro.getProcessId(), proTask.getProcessId())) {
                                        ProWorkOrderProcessItem proWorkOrderProcessItem = new ProWorkOrderProcessItem();
                                        proWorkOrderProcessItem.setWorkorderProcessId(pro.getWorkorderProcessId());
                                        List<ProWorkOrderProcessItem> processItemList = proWorkOrderProcessItemService.selectProWorkOrderProcessItemList(proWorkOrderProcessItem);
                                        if (CollectionUtil.isNotEmpty(processItemList)) {
                                            for (ProWorkOrderProcessItem item : processItemList) {
                                                if (Objects.equals(item.getItemId(), append.getItemId())) {
                                                    proMaterialRequest.setRequirementNumber(item.getRequirementNumber());
                                                    proMaterialRequest.setRequirementProjectNumber(item.getRequirementProjectNumber());
                                                }
                                            }
                                        }
                                    }

                                }
                            }
                            proMaterialRequest.setWorkunitId(mdWorkunit.getWorkunitId());
                            proMaterialRequest.setWorkstationCode(proTask.getWorkstationCode());
                            proMaterialRequest.setWorkstationName(proTask.getWorkstationName());
                            proMaterialRequest.setEndTime(proTaskWorkunit.getScheduleEndDate());
                            insertProMaterialRequest(proMaterialRequest);
                        }
                    }

                } else {
                    ProWorkorder proWorkorder = proWorkorderMapper.selectProWorkorderWorderCode(append.getWorkorderCode());
                    ProTask proTask = proTaskMapper.selectProTaskByTaskId(append.getTaskId());
                    QueryWrapper<ProWorkOrderProcess> queryWrapper = new QueryWrapper<>();
                    queryWrapper.eq("ss.workorder_code", append.getWorkorderCode());
                    queryWrapper.eq("ss.process_id", proTask.getProcessId());
                    queryWrapper.eq("it.item_id", append.getItemId());
                    ProWorkOrderProcessItem processItem = proWorkOrderProcessItemMapper.selectProWordorderAndProcess(queryWrapper);
                    ProMaterialRequest proMaterialRequest1 = new ProMaterialRequest();
                    proMaterialRequest1.setTaskId(append.getTaskId());
                    proMaterialRequest1.setWorkorderCode(append.getWorkorderCode());
                    List<ProMaterialRequest> proMaterialRequests = proMaterialRequestService.selectProMaterialRequestList(proMaterialRequest1);
                    List<ProMaterialRequest> collect1 = proMaterialRequests.stream().filter(s -> s.getMaterialType() == 1).collect(Collectors.toList());
                    BigDecimal bigDecimal1 = BigDecimal.ZERO;
                    for (ProMaterialRequest proMaterialRequest : collect1) {
                        bigDecimal1 = bigDecimal1.add(proMaterialRequest.getApplyNum());

                    }
                    if (bigDecimal1.add(append.getApplyNum()).compareTo(processItem.getQuantity()) > 0) {
                        BigDecimal subtract = processItem.getQuantity().subtract(bigDecimal1);
                        throw new ServiceException("直发料申请数量超过"+subtract+"工单" + append.getWorkorderCode() + "的任务数量");
                    }
                    if (!StringUtils.isNull(proWorkorder)) {
                        //查看工序
                        ProWorkOrderProcess proWorkOrderProcess = new ProWorkOrderProcess();
                        proWorkOrderProcess.setWorkorderId(proWorkorder.getWorkorderId());
                        List<ProWorkOrderProcessVo> proWorkOrderProcessVos = proWorkOrderProcessService.selectProWorkOrderProcessList(proWorkOrderProcess);
                        //根据任务单号查询工单关联的对应工序
                        for (ProWorkOrderProcessVo pro : proWorkOrderProcessVos) {
                            if (Objects.equals(pro.getProcessId(), proTask.getProcessId())) {
                                ProWorkOrderProcessItem proWorkOrderProcessItem = new ProWorkOrderProcessItem();
                                proWorkOrderProcessItem.setWorkorderProcessId(pro.getWorkorderProcessId());
                                List<ProWorkOrderProcessItem> processItemList = proWorkOrderProcessItemService.selectProWorkOrderProcessItemList(proWorkOrderProcessItem);
                                if (CollectionUtil.isNotEmpty(processItemList)) {
                                    for (ProWorkOrderProcessItem item : processItemList) {
                                        if (Objects.equals(item.getItemId(), append.getItemId())) {
                                            append.setRequirementNumber(item.getRequirementNumber());
                                            append.setRequirementProjectNumber(item.getRequirementProjectNumber());
                                        }
                                    }
                                }
                            }

                        }
                    }
                    append.setWorkunitId(mdWorkunit.getWorkunitId());
                    append.setWorkstationCode(proTask.getWorkstationCode());
                    append.setWorkstationName(proTask.getWorkstationName());
                    append.setApplyNo(tempCode);
                    append.setEndTime(proTaskWorkunit.getScheduleEndDate());
                    this.insertProMaterialRequest(append);
                }


            } else {

                //查看任务单对应的工单
                List<ProTaskWorkorder> proTaskWorkorders = proTaskWorkorderMapper.selectProTaskWorkorderTaskId(append.getTaskId());
                List<Long> collect1 = proTaskWorkorders.stream().map(ProTaskWorkorder::getWorkorderId).collect(Collectors.toList());
                QueryWrapper<ProWorkOrderProcess> queryWrapper = new QueryWrapper<>();
                queryWrapper.in("ss.workorder_id", collect1);
                queryWrapper.eq("it.item_id", append.getItemId());
                List<ProWorkOrderProcessItem> processItems = proWorkOrderProcessItemMapper.selectProWordorderAndProcess2(queryWrapper);
                BigDecimal reduce = processItems.stream().map(ProWorkOrderProcessItem::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                ProAllocationMaterial proAllocationMaterial1 = new ProAllocationMaterial();
                //查看调拨料已生产补料的数量合
                proAllocationMaterial1.setTaskId(append.getTaskId());
                proAllocationMaterial1.setSapItemCode(append.getSapItemCode());
                List<ProAllocationMaterial> proAllocationMaterials = proAllocationMaterialService.selectProAllocationMaterialList(proAllocationMaterial1);
                List<ProAllocationMaterial> collect = proAllocationMaterials.stream().filter(s -> s.getMaterialType() == 1).collect(Collectors.toList());
                BigDecimal bigDecimal = BigDecimal.ZERO;
                for (ProAllocationMaterial proAllocationMaterial : collect) {
                    bigDecimal = bigDecimal.add(proAllocationMaterial.getApplyNum());
                }
                //对比
                if(bigDecimal.add(append.getApplyNum()).compareTo(reduce)>0){
                    BigDecimal subtract = reduce.subtract(bigDecimal);
                    throw new ServiceException("倒冲料申请数量不能超过"+subtract+"任务数量");
                }
                MdItem mdItem = mdItemMapper.selectMdItemById(append.getItemId());
                MdWorkstation mdWorkstation = mdWorkstationMapper.selectMdWorkstationByWorkstationId(append.getWorkstationId());
                ProTask proTask = proTaskMapper.selectProTaskByTaskId(append.getTaskId());
                ProAllocationMaterial proAllocationMaterial = new ProAllocationMaterial();
                proAllocationMaterial.setApplyNo(s1);
                proAllocationMaterial.setSapItemCode(mdItem.getSapItemCode());
                proAllocationMaterial.setItemName(mdItem.getItemName());
                proAllocationMaterial.setWorkstationId(append.getWorkstationId());
                proAllocationMaterial.setWorkstationCode(mdWorkstation.getWorkstationCode());
                proAllocationMaterial.setTaskId(append.getTaskId());
                proAllocationMaterial.setTaskCode(proTask.getTaskCode());
                proAllocationMaterial.setApplyNum(append.getApplyNum());
                proAllocationMaterial.setStartTime(DateUtils.getNowDate());
                proAllocationMaterial.setEndTime(proTaskWorkunit.getScheduleEndDate());
                proAllocationMaterial.setCreateTime(DateUtils.getNowDate());
                proAllocationMaterial.setBuildMethod(0L);
                proAllocationMaterial.setMaterialType(1L);
                proAllocationMaterialService.insertProAllocationMaterial(proAllocationMaterial);
            }
        }


    }


    /**
     * 获取所有工单下相同工序和相同物料的收集
     *
     * @param append
     * @param material
     * @return
     */
    private List<ProMaterialRequestItemVo2> itemDistribution(ProMaterialRequest append, List<ProMaterialRequestItemVo2> material) {

        ProTask proTask = proTaskMapper.selectProTaskByTaskId(append.getTaskId());
        ProTaskWorkorder proTaskWorkorder = new ProTaskWorkorder();
        proTaskWorkorder.setTaskId(append.getTaskId());

        //查看任务和工单关联表
        List<ProTaskWorkorder> proTaskWorkorders = proTaskWorkorderMapper.selectProTaskWorkorderList(proTaskWorkorder);
        if (CollUtil.isEmpty(proTaskWorkorders)) {
            return null;
        }
        //获取关联表的所有工单id
        List<Long> workorderIdList = proTaskWorkorders.stream().map(ProTaskWorkorder::getWorkorderId).collect(Collectors.toList());
        for (Long workorderId : workorderIdList) {
            //查看工单的返回数据
            ProWorkorderVo proWorkorderVo = proWorkorderService.selectProWorkorderByWorkorderId(workorderId);
            if (StringUtils.isNull(proWorkorderVo)) {
                continue;
            }
            //查看工序
            List<ProWorkOrderProcessVo> processList = proWorkorderVo.getProcessList();
            if (StringUtils.isNull(processList)) {
                continue;
            }
            //根据任务单号查询工单关联的对应工序
            //根据工单工序ID查询物料
            for (ProWorkOrderProcessVo pro : processList) {
                if (!Objects.equals(pro.getProcessId(), proTask.getProcessId())) {
                    continue;
                }

                List<ProWorkOrderProcessItem> processItemList = pro.getProcessItemList();
                if (CollUtil.isNotEmpty(processItemList)) {
                    for (ProWorkOrderProcessItem item : processItemList) {
                        if (item.getIsBackflush() != "Y") {
                            if (Objects.equals(item.getItemId(), append.getItemId())) {
                                ProMaterialRequestItemVo2 materialRequestItem = new ProMaterialRequestItemVo2();
                                materialRequestItem.setApplyType(append.getApplyType());
                                materialRequestItem.setItemId(append.getItemId());
                                materialRequestItem.setPickingReason(append.getPickingReason());
                                materialRequestItem.setQuantity(item.getQuantity());
                                materialRequestItem.setWorkorderCode(proWorkorderVo.getWorkorderCode());
                                materialRequestItem.setApplyNum(append.getApplyNum());
                                materialRequestItem.setTaskId(append.getTaskId());
                                materialRequestItem.setRequirementNumber(item.getRequirementNumber());
                                materialRequestItem.setRequirementProjectNumber(item.getRequirementProjectNumber());
                                materialRequestItem.setTaskWorkunitId(append.getTaskWorkunitId());
                                materialRequestItem.setWorkunitId(append.getWorkunitId());
                                materialRequestItem.setWorkunitName(append.getWorkunitName());
                                materialRequestItem.setWorkunitCode(append.getWorkunitCode());
                                material.add(materialRequestItem);
                            }
                        }
                    }
                }
            }
        }

        return material;
    }

    /**
     * 修改领料申请
     *
     * @param proMaterialRequest 领料申请
     * @return 结果
     */
    @Override
    public int updateProMaterialRequest(ProMaterialRequest proMaterialRequest) {
        proMaterialRequest.createAction();
        return proMaterialRequestMapper.updateProMaterialRequest(proMaterialRequest);
    }

    @Override
    public void updateProMaterialRequestByTaskWorkunit(ProTaskWorkunit taskWorkunit) {
        QueryWrapper<ProMaterialRequest> query = new QueryWrapper<>();
        query.eq("task_workunit_id", taskWorkunit.getTaskWorkunitId());
        MdWorkunitVo mdWorkunitVo = mdWorkunitMapper.selectMdWorkunitByWorkunitId(taskWorkunit.getWorkunitId());
        List<ProMaterialRequest> list = this.selectList(query);
        list.forEach(s->{
            s.setWorkunitId(taskWorkunit.getWorkunitId());
            s.setWorkunitCode(mdWorkunitVo.getWorkunitCode());
            s.setWorkunitName(mdWorkunitVo.getWorkunitName());
            s.setWorkstationCode(mdWorkunitVo.getWorkstationCode());
            s.setWorkstationName(mdWorkunitVo.getWorkstationName());
            s.setStartTime(taskWorkunit.getScheduleStartDate());
            s.setEndTime(taskWorkunit.getScheduleEndDate());
            this.updateProMaterialRequest(s);
        });
    }

    /**
     * 批量删除领料申请
     *
     * @param materialRequestIds 需要删除的领料申请主键
     * @return 结果
     */
    @Override
    public int deleteProMaterialRequestByMaterialRequestIds(Long[] materialRequestIds) {
        return proMaterialRequestMapper.deleteProMaterialRequestByMaterialRequestIds(materialRequestIds);
    }

    /**
     * 删除领料申请信息
     *
     * @param materialRequestId 领料申请主键
     * @return 结果
     */
    @Override
    public int deleteProMaterialRequestByMaterialRequestId(Long materialRequestId) {
        return proMaterialRequestMapper.deleteProMaterialRequestByMaterialRequestId(materialRequestId);
    }


    @Override
    public void insertProMaterialRequestItemV2(ProTask proTaskVo) {
        //查看任务和工单关联表
        ProTaskWorkorder proTaskWorkorder = new ProTaskWorkorder();
        proTaskWorkorder.setTaskId(proTaskVo.getTaskId());
        List<ProTaskWorkorder> proTaskWorkorders = proTaskWorkorderMapper.selectProTaskWorkorderList(proTaskWorkorder);
        if (CollUtil.isEmpty(proTaskWorkorders)) {
            return;
        }

        //获取关联表的所有工单id
        List<Long> workorderIdList = proTaskWorkorders.stream().map(ProTaskWorkorder::getWorkorderId).collect(Collectors.toList());
        String materialRequestCode = autoCodeUtil.genSerialCode(UserConstants.MATERIAL_REQUEST_CODE, "");
        for (Long workorderId : workorderIdList) {
            //查看工单的返回数据
            ProWorkorderVo proWorkorderVo = proWorkorderService.selectProWorkorderByWorkorderId(workorderId);
            if (StringUtils.isNull(proWorkorderVo)) {
                continue;
            }

            //查看物料
//            List<ProWorkOrderBom> bomList = proWorkorderVo.getBomList();

            //查看工序
            List<ProWorkOrderProcessVo> processList = proWorkorderVo.getProcessList();
            if (StringUtils.isNull(processList)) {
                continue;
            }
            //根据任务单号查询工单关联的对应工序

            //根据工单工序ID查询物料
            for (ProWorkOrderProcessVo pro : processList) {
                if (!Objects.equals(pro.getProcessId(), proTaskVo.getProcessId())) {
                    continue;
                }

                ProMaterialRequest proMaterialRequest = new ProMaterialRequest();
                List<ProWorkOrderProcessItem> processItemList = pro.getProcessItemList();
                // 判断是否倒扣
                for (ProWorkOrderProcessItem proWorkOrderProcessItem : processItemList) {
                    if (!Objects.equals(proWorkOrderProcessItem.getIsBackflush(), "Y")) {
                        proMaterialRequest.setApplyNo(materialRequestCode);
                        proMaterialRequest.setItemId(proWorkOrderProcessItem.getItemId());
                        proMaterialRequest.setTaskId(proTaskVo.getTaskId());
                        proMaterialRequest.setWorkorderCode(proWorkorderVo.getWorkorderCode());
                        proMaterialRequest.setApplyType(1);
                        proMaterialRequest.setApplyNum(proWorkOrderProcessItem.getQuantity());
                        proMaterialRequest.setStartTime(proTaskVo.getStartTime());
                        proMaterialRequest.setEndTime(proTaskVo.getEndTime());
                        proMaterialRequest.setWorkunitId(proTaskVo.getWorkunitId());
                        proMaterialRequest.setRequirementNumber(proWorkOrderProcessItem.getRequirementNumber());
                        proMaterialRequest.setRequirementProjectNumber(proWorkOrderProcessItem.getRequirementProjectNumber());
                        proMaterialRequest.setWorkunitCode(proTaskVo.getWorkunitCode());
                        proMaterialRequest.setWorkunitName(proTaskVo.getWorkunitName());
                        proMaterialRequest.setTaskWorkunitId(proTaskVo.getTaskWorkunitId());
                        proMaterialRequest.setWindCase("N");
                        this.insertProMaterialRequest(proMaterialRequest);
                    }
                }

            }
        }
    }

    @Override
    public void insertProMaterialRequestItem(ProTaskVo proTaskVo) {
        ProTaskWorkorder proTaskWorkorder = new ProTaskWorkorder();
        proTaskWorkorder.setTaskId(proTaskVo.getTaskId());

        //查看任务和工单关联表
        List<ProTaskWorkorder> proTaskWorkorders = proTaskWorkorderMapper.selectProTaskWorkorderList(proTaskWorkorder);
        if (CollUtil.isEmpty(proTaskWorkorders)) {
            return;
        }
        ProTaskWorkunit proTaskWorkunit = proTaskWorkunitMapper.selectProTaskWorkunitByTaskWorkunitId(proTaskVo.getTaskWorkunitId());
        MdWorkunitVo mdWorkunitVo = mdWorkunitMapper.selectMdWorkunitByWorkunitId(proTaskWorkunit.getWorkunitId());
        MdWorkstation mdWorkstation = mdWorkstationMapper.selectMdWorkstationByWorkstationId(proTaskVo.getWorkstationId());


        //获取关联表的所有工单id
        String materialRequestCode = autoCodeUtil.genSerialCode(UserConstants.MATERIAL_REQUEST_CODE, "");
        List<Long> workorderIdList = proTaskWorkorders.stream().map(ProTaskWorkorder::getWorkorderId).collect(Collectors.toList());
        for (Long workorderId : workorderIdList) {
            //查看工单的返回数据
            ProWorkorderVo proWorkorderVo = proWorkorderService.selectProWorkorderByWorkorderId(workorderId);
            if (StringUtils.isNull(proWorkorderVo)) {
                continue;
            }

            //查看物料
//            List<ProWorkOrderBom> bomList = proWorkorderVo.getBomList();

            //查看工序
            List<ProWorkOrderProcessVo> processList = proWorkorderVo.getProcessList();
            if (StringUtils.isNull(processList)) {
                continue;
            }

            for (ProWorkOrderProcessVo pro : processList) {
                if (!Objects.equals(pro.getProcessId(), proTaskVo.getProcessId())) {
                    continue;
                }

                List<ProWorkOrderProcessItem> processItemList = pro.getProcessItemList();
                if (processItemList == null) {
                    continue;
                }

                // 判断是否倒扣
                ProMaterialRequest proMaterialRequest = new ProMaterialRequest();
                for (ProWorkOrderProcessItem proWorkOrderProcessItem : processItemList) {
                    if (!Objects.equals(proWorkOrderProcessItem.getIsBackflush(), "Y")) {
                        proMaterialRequest.setApplyNo(materialRequestCode);
                        proMaterialRequest.setItemId(proWorkOrderProcessItem.getItemId());
                        proMaterialRequest.setTaskId(proTaskVo.getTaskId());
                        proMaterialRequest.setWorkorderCode(proWorkorderVo.getWorkorderCode());
                        proMaterialRequest.setApplyType(1);
                        proMaterialRequest.setApplyNum(proWorkOrderProcessItem.getQuantity());
                        proMaterialRequest.setStartTime(proTaskVo.getStartTime());
                        proMaterialRequest.setEndTime(proTaskVo.getEndTime());
                        proMaterialRequest.setWorkunitId(mdWorkunitVo.getWorkunitId());
                        proMaterialRequest.setWorkunitCode(mdWorkunitVo.getWorkunitCode());
                        proMaterialRequest.setWorkunitName(mdWorkunitVo.getWorkunitName());
                        proMaterialRequest.setRequirementNumber(proWorkOrderProcessItem.getRequirementNumber());
                        proMaterialRequest.setRequirementProjectNumber(proWorkOrderProcessItem.getRequirementProjectNumber());
                        proMaterialRequest.setTaskWorkunitId(proTaskVo.getTaskWorkunitId());
                        proMaterialRequest.setWorkstationCode(mdWorkstation.getWorkstationCode());
                        proMaterialRequest.setWorkstationName(mdWorkstation.getWorkstationName());
                        proMaterialRequest.setWindCase("N");
                        this.insertProMaterialRequest(proMaterialRequest);
                    }
                }
            }
        }
    }

    @Override
    public List<ProMaterialRequestVo> selectProMaterialRequestLists(QueryWrapper<ProMaterialRequest> query) {
        return proMaterialRequestMapper.selectProMaterialRequestLisA(query);
    }


    @Override
    public void deleteByTaskWorknuitId(Long taskWorkunitId) {
        QueryWrapper<ProMaterialRequest> proMaterialRequestQueryWrapper = new QueryWrapper<>();
        proMaterialRequestQueryWrapper.eq("task_workunit_id", taskWorkunitId);
        proMaterialRequestMapper.deleteProMaterialRequest(proMaterialRequestQueryWrapper);
    }


    //根据生产领料变更结案状态和已发放数量
    @Override
    public void selectProMaterialRequestUpdateWindCaseGrantNum(WmIssueVo wm) {
        QueryWrapper<ProMaterialRequest> query = new QueryWrapper<>();
        query.eq(wm.getApplyNo() != null, "p.apply_no", wm.getApplyNo());
        List<ProMaterialRequestVo> proMaterialRequestVos = proMaterialRequestMapper.selectProMaterialRequestLis(query);
        MdItem mdItem = mdItemMapper.selectMdItemBySapItemCode(wm.getSapItemCode());
        for (ProMaterialRequestVo pro : proMaterialRequestVos) {
            ProMaterialRequest proMaterialRequest = new ProMaterialRequest();
            BeanUtil.copyProperties(pro, proMaterialRequest);
            if (Objects.equals(proMaterialRequest.getWorkorderCode(), wm.getWorkorderCode())) {
                if (Objects.equals(proMaterialRequest.getItemId(), mdItem.getItemId())) {
                    if (StringUtils.isNull(proMaterialRequest.getGrantNum())) {
                        proMaterialRequest.setGrantNum(wm.getQuantityIssued());
                    } else {
                        BigDecimal add = proMaterialRequest.getGrantNum().add(wm.getQuantityIssued());
                        proMaterialRequest.setGrantNum(add);
                    }

                    if (Objects.equals(wm.getWindCase(), "Y")) {
                        proMaterialRequest.setWindCase("Y");
                    }

                    proMaterialRequestMapper.updateProMaterialRequest(proMaterialRequest);
                }
            }
        }

    }

    /**
     * 生产排产生产的领料申请
     *
     * @param taskWorkunitId
     * @param proTask
     */
    @Override
    public void insertProMaterialRequestIssueItem(Long taskWorkunitId, ProTask proTask) {


        ProTaskWorkorder proTaskWorkorder = new ProTaskWorkorder();
        proTaskWorkorder.setTaskId(proTask.getTaskId());
        //查看任务和工单关联表
        List<ProTaskWorkorder> proTaskWorkorders = proTaskWorkorderMapper.selectProTaskWorkorderList(proTaskWorkorder);
        if (CollUtil.isEmpty(proTaskWorkorders)) {
            return;
        }
        ProTaskWorkunit proTaskWorkunit = proTaskWorkunitService.selectProTaskWorkunitByTaskWorkunitId(taskWorkunitId);
        MdWorkunitVo mdWorkunitVo = mdWorkunitMapper.selectMdWorkunitByWorkunitId(proTaskWorkunit.getWorkunitId());

        QueryWrapper<MdWorkstation> mdWorkstationQueryWrapper = new QueryWrapper<>();
        mdWorkstationQueryWrapper.eq("workstation_id", proTask.getWorkstationId());
        List<MdWorkstation> mdWorkstations = mdWorkstationMapper.selectListByQw(mdWorkstationQueryWrapper);
        ExceptionUtil.checkTrueThrowException(CollectionUtil.isEmpty(mdWorkstations), "工站为空");
        MdWorkstation mdWorkstation = mdWorkstations.get(0);
        //领料单编码自动生成
        String s = autoCodeUtil.genSerialCode(UserConstants.MATERIAL_REQUEST_CODE, "");
        //调拨料单编码自动生成
        String s1 = autoCodeUtil.genSerialCode(UserConstants.ALLOCATION_CODE, "");
        //获取关联表的所有工单id
        List<Long> workorderIdList = proTaskWorkorders.stream().map(ProTaskWorkorder::getWorkorderId).collect(Collectors.toList());
        //判断领料单有没有存在该任务号

        QueryWrapper<ProMaterialRequest> query = new QueryWrapper<>();
        query.eq(proTask.getTaskId() != null, "p.task_id", proTask.getTaskId());
        List<ProMaterialRequestVo> proMaterialRequestVos = proMaterialRequestMapper.selectProMaterialRequestLis(query);
        List<ProAllocationMaterial> allocationList = new ArrayList<>();
        if (CollUtil.isEmpty(proMaterialRequestVos)) {
            for (Long workorderId : workorderIdList) {
                ProWorkorder proWorkorder = proWorkorderMapper.selectWorkorderById(workorderId);
                if (Objects.isNull(proWorkorder)) {
                    continue;
                }
                List<ProWorkOrderProcessVo> proWorkOrderProcessList = proWorkOrderProcessMapper.selectProWorkOrderProcessByWorkOrderId(workorderId);
                if (CollUtil.isNotEmpty(proWorkOrderProcessList)) {
                    for (ProWorkOrderProcessVo proprocess : proWorkOrderProcessList) {
                        if (Objects.equals(proprocess.getProcessId(), proTask.getProcessId())) {

                            List<ProWorkOrderProcessItem> processItemList = proWorkOrderProcessItemMapper.selectProWorkOrderProcessItemByWorkorderProcessId(proprocess.getWorkorderProcessId());
                            if (CollUtil.isEmpty(processItemList)) {
                                continue;
                            }
                            for (ProWorkOrderProcessItem proWorkOrderProcessItem : processItemList) {
                                QueryWrapper<MdItem> queryWrapper = new QueryWrapper<>();
                                queryWrapper.eq("item_id", proWorkOrderProcessItem.getItemId());
                                List<MdItem> mdItems = mdItemMapper.selectListByQw(queryWrapper);
                                if (CollectionUtil.isNotEmpty(mdItems)) {
                                    MdItem mdItem = mdItems.get(0);
                                    if (!proWorkOrderProcessItem.getIsBackflush().equals("Y")) {
                                        // 判断是否倒扣
                                        ProMaterialRequest proMaterialRequest1 = new ProMaterialRequest();
                                        proMaterialRequest1.setApplyNo(s);
                                        proMaterialRequest1.setItemId(proWorkOrderProcessItem.getItemId());
                                        proMaterialRequest1.setTaskId(proTask.getTaskId());
                                        proMaterialRequest1.setWorkorderCode(proWorkorder.getWorkorderCode());
                                        proMaterialRequest1.setApplyType(1);
                                        proMaterialRequest1.setApplyNum(proWorkOrderProcessItem.getQuantity());
                                        proMaterialRequest1.setStartTime(proTaskWorkunit.getScheduleStartDate());
                                        proMaterialRequest1.setEndTime(proTaskWorkunit.getScheduleEndDate());
                                        proMaterialRequest1.setWorkunitId(proTaskWorkunit.getWorkunitId());
                                        proMaterialRequest1.setWorkunitCode(mdWorkunitVo.getWorkunitCode());
                                        proMaterialRequest1.setWorkunitName(mdWorkunitVo.getWorkunitName());
                                        proMaterialRequest1.setTaskWorkunitId(taskWorkunitId);
                                        proMaterialRequest1.setRequirementNumber(proWorkOrderProcessItem.getRequirementNumber());
                                        proMaterialRequest1.setRequirementProjectNumber(proWorkOrderProcessItem.getRequirementProjectNumber());
                                        proMaterialRequest1.setWorkstationCode(mdWorkstation.getWorkstationCode());
                                        proMaterialRequest1.setWorkstationName(mdWorkstation.getWorkstationName());
                                        proMaterialRequest1.setWindCase("N");
                                        this.insertProMaterialRequest(proMaterialRequest1);
                                    } else {
                                        //是倒扣
                                        if (CollUtil.isEmpty(allocationList)) {
                                            ProAllocationMaterial proAllocationMaterial = new ProAllocationMaterial();
                                            proAllocationMaterial.setApplyNo(s1);
                                            proAllocationMaterial.setSapItemCode(mdItem.getSapItemCode());
                                            proAllocationMaterial.setItemName(mdItem.getItemName());
                                            proAllocationMaterial.setWorkstationId(proTask.getWorkstationId());
                                            proAllocationMaterial.setWorkstationCode(mdWorkstation.getWorkstationCode());
                                            proAllocationMaterial.setTaskId(proTask.getTaskId());
                                            proAllocationMaterial.setTaskWorkunitId(proTaskWorkunit.getTaskWorkunitId());
                                            proAllocationMaterial.setTaskCode(proTask.getTaskCode());
                                            proAllocationMaterial.setApplyNum(proWorkOrderProcessItem.getQuantity());
                                            proAllocationMaterial.setStartTime(proTaskWorkunit.getScheduleStartDate());
                                            proAllocationMaterial.setEndTime(proTaskWorkunit.getScheduleEndDate());
                                            proAllocationMaterial.setBuildMethod(1L);
                                            proAllocationMaterial.setMaterialType(0L);
                                            allocationList.add(proAllocationMaterial);
                                        } else {
                                            for (ProAllocationMaterial all : allocationList) {
                                                boolean a = false;
                                                //判断有没有相同的物料数量相加
                                                if (all.getSapItemCode().equals(mdItem.getSapItemCode())) {
                                                    BigDecimal add = all.getApplyNum().add(proWorkOrderProcessItem.getQuantity());
                                                    all.setApplyNum(add);
                                                    a = true;
                                                }
                                                //没有相同的物料新增数据
                                                if (!a) {
                                                    ProAllocationMaterial proAllocationMaterial = new ProAllocationMaterial();
                                                    proAllocationMaterial.setApplyNo(s1);
                                                    proAllocationMaterial.setSapItemCode(mdItem.getSapItemCode());
                                                    proAllocationMaterial.setItemName(mdItem.getItemName());
                                                    proAllocationMaterial.setWorkstationId(proTask.getWorkstationId());
                                                    proAllocationMaterial.setWorkstationCode(mdWorkstation.getWorkstationCode());
                                                    proAllocationMaterial.setTaskId(proTask.getTaskId());
                                                    proAllocationMaterial.setTaskCode(proTask.getTaskCode());
                                                    proAllocationMaterial.setTaskWorkunitId(proTaskWorkunit.getTaskWorkunitId());
                                                    proAllocationMaterial.setApplyNum(proWorkOrderProcessItem.getQuantity());
                                                    proAllocationMaterial.setStartTime(proTaskWorkunit.getScheduleStartDate());
                                                    proAllocationMaterial.setEndTime(proTaskWorkunit.getScheduleEndDate());
                                                    proAllocationMaterial.setBuildMethod(1L);
                                                    proAllocationMaterial.setMaterialType(0L);
                                                    allocationList.add(proAllocationMaterial);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

            if (CollUtil.isNotEmpty(allocationList)) {
                //新增调拨料数据
                for (ProAllocationMaterial all : allocationList) {
                    proAllocationMaterialService.insertProAllocationMaterial(all);
                }
            }
        }
    }

    @Override
    public int insertProMaterialRequestCreate(ProMaterialRequest proMaterialRequest) {
        List<ProAllocationItemList> itemList = proMaterialRequest.getItemList();
        ProTask proTask = proTaskMapper.selectProTaskByTaskId(proMaterialRequest.getTaskId());
        ProTaskWorkunit proTaskWorkunit = proTaskWorkunitMapper.selectProTaskWorkunitByTaskId(proMaterialRequest.getTaskId());
        ProWorkorder proWorkorder = proWorkorderMapper.selectProWorkorderWorderCode(proMaterialRequest.getWorkorderCode());
        List<ProWorkOrderProcessVo> proWorkOrderProcessVos = proWorkOrderProcessMapper.selectProWorkOrderProcessByWorkOrderId(proWorkorder.getWorkorderId());

        if (CollUtil.isNotEmpty(itemList)) {
            for (ProAllocationItemList list : itemList) {
                ProMaterialRequest proMaterialRequest1 = new ProMaterialRequest();
                BeanUtils.copyProperties(proMaterialRequest, proMaterialRequest1);
                BeanUtils.copyProperties(list, proMaterialRequest1);
                proMaterialRequest1.setTaskWorkunitId(proTaskWorkunit.getTaskWorkunitId());
                MdWorkstation mdWorkstation = mdWorkstationMapper.selectMdWorkstationByWorkstationCodes(list.getWorkstationCode());
                MdWorkunit mdWorkunit = mdWorkunitMapper.selectMdWorkunitByWorkunitCodes(list.getWorkunitCode());
                for (ProWorkOrderProcessVo processVo : proWorkOrderProcessVos) {
                    if (processVo.getProcessId().equals(proTask.getProcessId())) {
                        for (ProWorkOrderProcessItem item : proWorkOrderProcessItemMapper.selectProWorkOrderProcessItemByWorkorderProcessId(processVo.getWorkorderProcessId())) {
                            if (list.getItemId().equals(item.getItemId())) {
                                proMaterialRequest1.setRequirementNumber(item.getRequirementNumber());
                                proMaterialRequest1.setRequirementProjectNumber(item.getRequirementProjectNumber());
                            }
                        }
                    }
                }
                proMaterialRequest1.setWorkunitId(mdWorkunit.getWorkunitId());
                proMaterialRequest1.setWorkunitName(mdWorkunit.getWorkunitName());
                proMaterialRequest1.setWorkstationName(mdWorkstation.getWorkstationName());
                proMaterialRequest1.setWorkstationCode(mdWorkstation.getWorkstationCode());
                proMaterialRequest1.setApplyType(1);
                proMaterialRequest1.setWindCase("N");
                proMaterialRequestMapper.insertProMaterialRequest(proMaterialRequest1);
            }
        }

        return 1;
    }

    @Override
    public boolean checkMaterialRequestIsExist(Long taskWorkunitId) {
        QueryWrapper<ProWorkOrderProcessItem> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("ptw.task_workunit_id", taskWorkunitId);
        queryWrapper.eq("is_backflush", "N");
        return CollectionUtil.isNotEmpty(proWorkOrderProcessItemMapper.selectProcessItemByQw(queryWrapper));
    }

    @Override
    public void checkMaterialRequest(ProTask task) {
        String arrangeCode = task.getArrangeCode();

        Set<Long> itemIds = proMaterialRequestMapper.selectListByQw(new QueryWrapper<ProMaterialRequest>().eq("arrange_code", arrangeCode)).stream().map(ProMaterialRequestVo::getItemId).collect(Collectors.toSet());

        if (CollectionUtil.isNotEmpty(itemIds)) {
            WmIssueLine wmIssueLine = new WmIssueLine();
            wmIssueLine.setTaskId(task.getTaskId());
            List<WmIssueLineJoinBean> wmIssueLineJoinBeans = wmIssueLineService.selectWmIssueLineBeanList(wmIssueLine);
            ExceptionUtil.checkTrueThrowException(CollectionUtil.isNotEmpty(wmIssueLineJoinBeans.stream().filter(x -> x.getAttr3() == 0).collect(Collectors.toList())), "投料未全部检查");
            for (WmIssueLineJoinBean wmIssueLineJoinBean : wmIssueLineJoinBeans) {
                itemIds.remove(wmIssueLineJoinBean.getItemId());
            }

            ExceptionUtil.checkTrueThrowException(CollectionUtil.isNotEmpty(itemIds), "申请的物料未全部领料");
        }
    }


    @Override
    public List<ProMaterialRequestVo> selectMaterialRequestPrintTab(MaterialRequestIds materialRequestIds) {
        // 从 MaterialRequestIds 获取 ids 列表
        List<String> ids = materialRequestIds.getIds();
        // 根据 ids 列表查询物料申请的打印表数据
        List<ProMaterialRequestVo> proMaterialRequestVos = proMaterialRequestMapper.selectMaterialRequestPrintTab(ids);
        AtomicInteger count = new AtomicInteger(1);
        //new一个arraylist集合
        List<ProMaterialRequestVo> proMaterialRequestVos1 = new ArrayList<>();
        proMaterialRequestVos.forEach(x -> {
            //用这个ApplyNo字段去数据库查询
            String applyNo = x.getApplyNo();
            if (StringUtils.isNotEmpty(applyNo)) {
                //用这个ApplyNo字段去数据库查询,接收多个结果
                List<ProMaterialRequestVo> proMaterialRequestVo = proMaterialRequestMapper.selectMaterialRequestPrintTabByApplyNo(applyNo);
                //查到的数据添加到新建的那个集合里
                proMaterialRequestVos1.addAll(proMaterialRequestVo);
                // 设置打印时间是当前时间
                x.setPrintTime(new Date());
                // 设置序列号,起始为1然后累加
                x.setSerialNumber(String.valueOf(count.getAndIncrement()));
            }
        });
        proMaterialRequestVos1.forEach(x -> {
            // 设置打印时间是当前时间
            x.setPrintTime(new Date());
            // 设置序列号,起始为1然后累加
            x.setSerialNumber(String.valueOf(count.getAndIncrement()));
        });
        return proMaterialRequestVos;
    }

    @Override
    public boolean checkMaterialRequestExist(Long workunitId) {
        ProTaskWorkunit proTaskWorkunit = proTaskWorkunitMapper.selectProTaskWorkunitByTaskWorkunitId(workunitId);
        List<ProWorkOrderBomVo> proWorkOrderBomVos = selectMaterialLists(proTaskWorkunit.getTaskId());
        return CollectionUtil.isNotEmpty(proWorkOrderBomVos);
    }

    @Override
    public List<ProWorkOrderBomVo> selectMaterialLists(Long taskId) {
        //查询关联所有工单
        QueryWrapper<ProTask> query = new QueryWrapper<>();
        query.eq("t1.task_Id", taskId);
        List<ProTaskVo> taskOrderlist = proTaskMapper.selectProTaskJoinWorkorder(query);
        ProTask proTask = proTaskMapper.selectProTaskByTaskId(taskId);
        //查询生产任务关联工单
        List<Long> workorderIds = taskOrderlist.stream().map(ProTaskVo::getWorkorderId).collect(Collectors.toList());

        //根据工单查询物料清单
        QueryWrapper<ProWorkOrderProcessVo> query2 = new QueryWrapper<>();
        query2.in("m.workorder_id", workorderIds);
        query2.eq("m.process_id", proTask.getProcessId());
        //      List<ProWorkOrderBomVo> list = proWorkOrderBomMapper.selectProWorkOrderBomJoinItem(query2);
        List<ProWorkOrderBomVo> list = proWorkorderMapper.selectProWorkOrderJoinItem(query2);
        return list;
    }

}
