package com.ximai.mes.pro.service.impl;

import java.util.List;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.pro.domain.ProBomItem;
import com.ximai.mes.pro.mapper.ProBomItemMapper;
import com.ximai.mes.pro.service.IProBomItemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * BOM组件Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
@Service
public class ProBomItemServiceImpl implements IProBomItemService
{
    @Autowired
    private ProBomItemMapper proBomItemMapper;

    /**
     * 查询BOM组件
     *
     * @param bomItemId BOM组件主键
     * @return BOM组件
     */
    @Override
    public ProBomItem selectProBomItemByBomItemId(Long bomItemId)
    {
        return proBomItemMapper.selectProBomItemByBomItemId(bomItemId);
    }

    /**
     * 查询BOM组件列表
     *
     * @param proBomItem BOM组件
     * @return BOM组件
     */
    @Override
    public List<ProBomItem> selectProBomItemList(ProBomItem proBomItem)
    {
        return proBomItemMapper.selectProBomItemList(proBomItem);
    }

    /**
     * 新增BOM组件
     *
     * @param proBomItem BOM组件
     * @return 结果
     */
    @Override
    public int insertProBomItem(ProBomItem proBomItem)
    {
        proBomItem.setCreateTime(DateUtils.getNowDate());
        return proBomItemMapper.insertProBomItem(proBomItem);
    }

    /**
     * 修改BOM组件
     *
     * @param proBomItem BOM组件
     * @return 结果
     */
    @Override
    public int updateProBomItem(ProBomItem proBomItem)
    {
        proBomItem.setUpdateTime(DateUtils.getNowDate());
        return proBomItemMapper.updateProBomItem(proBomItem);
    }

    /**
     * 批量删除BOM组件
     *
     * @param bomItemIds 需要删除的BOM组件主键
     * @return 结果
     */
    @Override
    public int deleteProBomItemByBomItemIds(Long[] bomItemIds)
    {
        return proBomItemMapper.deleteProBomItemByBomItemIds(bomItemIds);
    }

    /**
     * 删除BOM组件信息
     *
     * @param bomItemId BOM组件主键
     * @return 结果
     */
    @Override
    public int deleteProBomItemByBomItemId(Long bomItemId)
    {
        return proBomItemMapper.deleteProBomItemByBomItemId(bomItemId);
    }
}
