package com.ximai.mes.pro.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.SecurityUtils;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.md.mapper.MdWorkunitMapper;
import com.ximai.mes.md.vo.MdWorkunitVo;
import com.ximai.mes.pro.domain.ProAllocationMaterial;
import com.ximai.mes.pro.domain.task.ProTaskWorkunit;
import com.ximai.mes.pro.domain.vo.ProAllocationItemList;
import com.ximai.mes.pro.domain.vo.ProAllocationMaterialVo;
import com.ximai.mes.pro.mapper.ProAllocationMaterialMapper;
import com.ximai.mes.pro.service.IProAllocationMaterialService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.List;

/**
 * 调拨料申请Service业务层处理
 *
 * @author generator
 * @date 2024-05-14
 */
@Service
public class ProAllocationMaterialServiceImpl implements IProAllocationMaterialService {
    @Autowired
    private ProAllocationMaterialMapper proAllocationMaterialMapper;
    @Autowired
    private MdWorkunitMapper mdWorkunitMapper;

    /**
     * 查询调拨料申请
     *
     * @param allocationMaterialId 调拨料申请主键
     * @return 调拨料申请
     */
    @Override
    public ProAllocationMaterial selectProAllocationMaterialByAllocationMaterialId(Long allocationMaterialId) {
        return proAllocationMaterialMapper.selectProAllocationMaterialByAllocationMaterialId(allocationMaterialId);
    }

    /**
     * 查询调拨料申请列表
     *
     * @param proAllocationMaterial 调拨料申请
     * @return 调拨料申请
     */
    @Override
    public List<ProAllocationMaterial> selectProAllocationMaterialList(ProAllocationMaterial proAllocationMaterial) {
        return proAllocationMaterialMapper.selectProAllocationMaterialList(proAllocationMaterial);
    }

    @Override
    public List<ProAllocationMaterial> selectProAllocationMaterialList(QueryWrapper<ProAllocationMaterial> query) {
        return proAllocationMaterialMapper.selectProAllocationMaterialListByQw(query);
    }

    /**
     * 自动新增新增调拨料申请
     *
     * @param proAllocationMaterial 调拨料申请
     * @return 结果
     */
    @Override
    public int insertProAllocationMaterial(ProAllocationMaterial proAllocationMaterial) {
        proAllocationMaterial.setCreateBy(SecurityUtils.getUsername());
        proAllocationMaterial.setWindCase("N");
        return proAllocationMaterialMapper.insertProAllocationMaterial(proAllocationMaterial);
    }


    /**
     * 手动新增调拨料申请
     *
     * @param proAllocationMaterialVo 调拨料申请
     * @return 结果
     */
    @Override
    public int insertProAllocationMaterialManual(ProAllocationMaterialVo proAllocationMaterialVo) {
        int i = 0;
        for (ProAllocationItemList itemList : proAllocationMaterialVo.getItemList()) {
            ProAllocationMaterial proAllocationMaterial = new ProAllocationMaterial();
            BeanUtils.copyProperties(proAllocationMaterialVo, proAllocationMaterial);
            BeanUtils.copyProperties(itemList, proAllocationMaterial);
            proAllocationMaterial.setCreateBy(SecurityUtils.getUsername());
            proAllocationMaterial.setWindCase("N");
            proAllocationMaterialMapper.insertProAllocationMaterial(proAllocationMaterial);
        }


        return i;
    }

    /**
     * 修改调拨料申请
     *
     * @param proAllocationMaterial 调拨料申请
     * @return 结果
     */
    @Override
    public int updateProAllocationMaterial(ProAllocationMaterial proAllocationMaterial) {
        proAllocationMaterial.setUpdateBy(SecurityUtils.getUsername());
        return proAllocationMaterialMapper.updateProAllocationMaterial(proAllocationMaterial);
    }

    @Override
    public void updateProAllocationMaterialByTaskWorkunit(ProTaskWorkunit taskWorkunit) {
        QueryWrapper<ProAllocationMaterial> query = new QueryWrapper<>();
        query.eq("task_workunit_id", taskWorkunit.getTaskWorkunitId());
        MdWorkunitVo mdWorkunitVo = mdWorkunitMapper.selectMdWorkunitByWorkunitId(taskWorkunit.getWorkunitId());
        List<ProAllocationMaterial> list = this.selectProAllocationMaterialList(query);
        list.forEach(s->{
            s.setStartTime(taskWorkunit.getScheduleStartDate());
            s.setEndTime(taskWorkunit.getScheduleEndDate());
            s.setWorkstationId(mdWorkunitVo.getWorkstationId());
            s.setWorkstationCode(mdWorkunitVo.getWorkstationCode());
            this.updateProAllocationMaterial(s);
        });
    }

    /**
     * 批量删除调拨料申请
     *
     * @param allocationMaterialIds 需要删除的调拨料申请主键
     * @return 结果
     */
    @Override
    public int deleteProAllocationMaterialByAllocationMaterialIds(Long[] allocationMaterialIds) {
        return proAllocationMaterialMapper.deleteProAllocationMaterialByAllocationMaterialIds(allocationMaterialIds);
    }

    /**
     * 删除调拨料申请信息
     *
     * @param allocationMaterialId 调拨料申请主键
     * @return 结果
     */
    @Override
    public int deleteProAllocationMaterialByAllocationMaterialId(Long allocationMaterialId) {
        return proAllocationMaterialMapper.deleteProAllocationMaterialByAllocationMaterialId(allocationMaterialId);
    }

    @Override
    @Transactional
    public void insertProAllocationMaterialList(List<ProAllocationMaterial> proAllocationMaterials) {
        if (CollUtil.isEmpty(proAllocationMaterials) && proAllocationMaterials.size() == 0) {
            ExceptionUtil.checkTrueThrowException(true, "没传数据");
        }
        for (ProAllocationMaterial pro : proAllocationMaterials) {
            ProAllocationMaterial proAllocationMaterial = new ProAllocationMaterial();
            proAllocationMaterial.setApplyNo(pro.getApplyNo());
            List<ProAllocationMaterial> proAllocationMaterials1 = proAllocationMaterialMapper.selectProAllocationMaterialList(proAllocationMaterial);
            for (ProAllocationMaterial allocation : proAllocationMaterials1) {
                if (pro.getSapItemCode().equals(allocation.getSapItemCode())) {
                    if (StringUtils.isNull(allocation.getAllocationNum())) {
                        allocation.setAllocationNum(pro.getAllocationNum());
                        allocation.setWindCase(pro.getWindCase());
                        allocation.setAllocationMaterialId(allocation.getAllocationMaterialId());
                        proAllocationMaterialMapper.updateProAllocationMaterial(allocation);
                    } else {
                        BigDecimal add = allocation.getAllocationNum().add(pro.getAllocationNum());
                        allocation.setAllocationNum(add);
                        allocation.setWindCase(pro.getWindCase());
                        allocation.setAllocationMaterialId(allocation.getAllocationMaterialId());
                        proAllocationMaterialMapper.updateProAllocationMaterial(allocation);
                    }
                }
            }

        }
    }
}
