package com.ximai.mes.pro.service;

import com.ximai.mes.pro.domain.ProCombination;

import java.util.List;

/**
 * 生产组合单Service接口
 *
 * @author generator
 * @date 2024-02-28
 */
public interface IProCombinationService {

    /**
     * 查询生产组合单
     *
     * @param combinationId 生产组合单主键
     * @return 生产组合单
     */
    ProCombination selectProCombinationByCombinationId(Long combinationId);

    /**
     * 查询生产组合单列表
     *
     * @param proCombination 生产组合单
     * @return 生产组合单集合
     */
    List<ProCombination> selectProCombinationList(ProCombination proCombination);

    /**
     * 查询生产组合单列表
     *
     * @param proCombination 生产组合单
     * @return 生产组合单集合
     */
    List<ProCombination> selectProCombList(ProCombination proCombination);


    /**
     * 新增生产组合单
     *
     * @param proCombination 生产组合单
     * @return 结果
     */
    int insertProCombination(ProCombination proCombination);


    List<String> batchAddProCombination(List<ProCombination> proCombinations);

    List<String> batchAddProCombinationV2(List<ProCombination> proCombination);


    /**
     * 修改生产组合单
     *
     * @param proCombination 生产组合单
     * @return 结果
     */
    int updateProCombination(ProCombination proCombination);

    /**
     * 批量删除生产组合单
     *
     * @param combinationIds 需要删除的生产组合单主键集合
     * @return 结果
     */
    int deleteProCombinationByWorkorderIds(Long[] combinationIds);

    /**
     * 删除生产组合单信息
     *
     * @param combinationId 生产组合单主键
     * @return 结果
     */
    int deleteProCombinationByCombinationId(Long combinationId);
}
