package com.ximai.mes.pro.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.ProArrange;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import com.ximai.mes.pro.domain.vo.ProArrangeQuery;
import com.ximai.mes.pro.domain.vo.proWorkOrder.WorkOrderArrangeResult;

import java.util.List;

/**
 * 生产编排单Service接口
 *
 * @author generator
 * @date 2024-03-01
 */
public interface IProArrangeService {

    static String ARRANGE_GROUP_CODE = "ARRANGE_GROUP_CODE";

    /**
     * 查询生产编排单
     *
     * @param arrangeId 生产编排单主键
     * @return 生产编排单
     */
    ProArrange selectProArrangeByArrangeId(Long arrangeId);


    ProArrange selectProArrangeByWorkorderId(Long workorderId);

    /**
     * 查询生产编排单列表
     *
     * @param proArrange 生产编排单
     * @return 生产编排单集合
     */
    List<ProArrange> selectProArrangeList(ProArrange proArrange);

    /**
     * 查询生产编排单列表
     *
     * @param query 生产编排单
     * @return 生产编排单集合
     */
    List<ProArrange> selectProArrangeList(QueryWrapper<ProArrange> query);

    /**
     * 查询生产编排单列表
     *
     * @param query 生产编排单
     * @return 生产编排单
     */
    List<ProArrange> selectJoinWorkorderGroupByArrangeCode(QueryWrapper<ProArrange> query);

    /**
     * 查询生产编排单列表
     *
     * @param proArrange 生产编排单
     * @return 生产编排单集合
     */
    List<ProArrange> selectProArrangeGroupList(ProArrange proArrange);

    /**
     * 新增生产编排单
     *
     * @param proArrange 生产编排单
     * @return 结果
     */
    int insertProArrange(ProArrange proArrange);

    /**
     * 新增生产编排单
     *
     * @param proArrange 生产编排单
     * @return 结果
     */
    String batchAddProArrange(List<ProArrange> proArrange);


    /**
     * 修改生产编排单
     *
     * @param proArrange 生产编排单
     * @return 结果
     */
    int updateProArrange(ProArrange proArrange);

    /**
     * 批量删除生产编排单
     *
     * @param arrangeIds 需要删除的生产编排单主键集合
     * @return 结果
     */
    int deleteProArrangeByWorkorderIds(Long[] arrangeIds);

    /**
     * 删除生产编排单信息
     *
     * @param arrangeId 生产编排单主键
     * @return 结果
     */
    int deleteProArrangeByArrangeId(Long arrangeId);

    /**
     * 工单编排
     *
     * @param workorderList
     * @return
     */
    WorkOrderArrangeResult arrangeExecute(List<ProWorkorder> workorderList);

    /**
     * 工单编排拆分
     * 生成新的编排单号
     *
     * @param arrangeIds
     * @return
     */
    void split(Long[] arrangeIds);


    /**
     * 编排追加工单
     *
     * @param arrangeCode
     * @param workorderIds
     * @return
     */
    void appendArrange(String arrangeCode, Long[] workorderIds);

    void deleteByWorkorderCode(String workorderCode);

    List<ProArrange> selectDistictArrangeList(ProArrangeQuery query);
}
