package com.ximai.mes.pro.mapper.task;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.pro.domain.vo.ProTaskVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 生产任务Mapper接口
 *
 * @date 2022-05-14
 */
public interface ProTaskMapper extends BaseMapper<ProTask> {
    /**
     * 查询生产任务
     *
     * @param taskId 生产任务主键
     * @return 生产任务
     */
    ProTask selectProTaskByTaskId(Long taskId);


    @Select(value = "select * from pro_task where task_id=#{taskId}")
    ProTask selectProTaskByTaskIds(@Param("taskId") Long taskId);


    @Select(value = "select t1.*,mw.workunit_code,mw.workunit_name from (select schedule_start_date,schedule_end_date,workunit_id from pro_task_workunit ptw left join pro_task pt on ptw.task_id = pt.task_id where pt.arrange_code=#{arrangeCode} and pt.process_id=#{processId} and ptw.schedule_start_date = (select max(schedule_start_date ) from pro_task_workunit ptw left join pro_task pt on ptw.task_id = pt.task_id where pt.arrange_code=#{arrangeCode} and pt.process_id=#{processId} ) limit 1) t1 left join md_workunit mw on t1.workunit_id = mw.workunit_id ")
    ProTask selectByArrangeCodeAndProcessId(@Param("arrangeCode") String arrangeCode, @Param("processId") Long processId);

    /**
     * 查询生产任务
     *
     * @param taskCode 生产任务主键
     * @return 生产任务
     */
    ProTask selectProTaskByTaskCode(String taskCode);

    /**
     * 查询生产任务列表
     *
     * @param proTask 生产任务
     * @return 生产任务集合
     */
    List<ProTask> selectProTaskList(ProTask proTask);


    /**
     * 查询生产任务列表
     *
     * @param query 生产任务
     * @return 生产任务集合
     */
    @Select("     select tw.task_workunit_id, t.task_id,t.arrange_code,t.task_code,t.task_name,t.workstation_id,\n" +
            "            ws.workstation_code,ws.workstation_name,t.process_id,p.process_code,\n" +
            "            p.process_name,t.item_id,i.item_code,i.item_name,t.specification,\n" +
            "            t.unit_of_measure,t.quantity,t.quantity_wait,t.quantity_produced,\n" +
            "\t\t\t\t\t\tt.quantity_changed,t.client_id,t.status,t.arrange_code,t.task_batch,\n" +
            "            t.ordinal,t.is_last_process,tw.schedule_start_date,tw.schedule_end_date\n" +
            "        from  pro_task_workunit tw \n" +
            "                 left join  pro_task t on tw.task_id=t.task_id\n" +
            "                 left join pro_process p on t.process_id = p.process_id\n" +
            "                 left join md_item i\n" +
            "                           on t.item_id = i.item_id\n" +
            "                 left join md_workstation ws\n" +
            "                           on t.workstation_id = ws.workstation_id\n" +
            "\t\t\t\t\t\t\t\t  ${ew.customSqlSegment} \t\t")
    List<ProTask> selectProTaskLists(@Param("ew") QueryWrapper<ProTask> query);

    /**
     * 查询生产任务列表
     *
     * @param proTask 生产任务
     * @return 生产任务集合
     */
    List<ProTask> selectProTaskDetailList(ProTask proTask);

    /**
     * 查询生产任务列表
     *
     * @param proTask 生产任务
     * @return 生产任务集合
     */
    @Select("select ptw.task_workunit_id, t.task_id, t.task_code, t.task_name, t.workstation_id\n" +
            "\t, ws.workstation_code, ws.workstation_name, t.process_id, t.arrange_code, p.process_code\n" +
            "\t, p.process_name, i.item_id, i.item_code, i.item_name, t.specification\n" +
            "\t, t.client_id, t.client_code, t.client_name, t.client_nick, t.start_time\n" +
            "\t, t.duration, t.end_time, t.color_code, t.request_date, t.remark\n" +
            "\t, t.attr1, t.attr2, t.attr3, t.attr4, t.create_by\n" +
            "\t, t.create_time, t.update_by, t.update_time, ptw.task_workunit_id, ptw.quantity\n" +
            "\t, ptw.quantity_produced, ptw.quantity_changed, ptw.quantity_qualify, ptw.unit_of_measure, ptw.STATUS\n" +
            "\t, mw.workunit_name as workunit_name, mw.workunit_id as workunit_id, mw.workunit_code as workunit_code, ptw.quantity_unqualify\n" +
            "from pro_task_workunit ptw\n" +
            "\tleft join pro_task t on t.task_id = ptw.task_id\n" +
            "    \tleft join (select * from pro_workorder t1 where t1.arrange_code = #{arrangeCode} limit 1) pw on t.arrange_code = pw.arrange_code\n" +
            "\tleft join pro_process p on t.process_id = p.process_id\n" +
            "\tleft join md_item i on pw.product_id = i.item_id\n" +
            "\tleft join md_workunit mw on ptw.workunit_id = mw.workunit_id\n" +
            "\tleft join md_workstation ws on t.workstation_id = ws.workstation_id\n" +
            "where ptw.task_workunit_id = #{taskWorkunitId}")
    List<ProTask> selectProTaskVoList(@Param("taskWorkunitId") Long taskWorkunitId, @Param("arrangeCode") String arrangeCode);

    /**
     * 新增生产任务
     *
     * @param proTask 生产任务
     * @return 结果
     */
    int insertProTask(ProTask proTask);

    /**
     * 修改生产任务
     *
     * @param proTask 生产任务
     * @return 结果
     */
    int updateProTask(ProTask proTask);

    /**
     * 删除生产任务
     *
     * @param taskId 生产任务主键
     * @return 结果
     */
    int deleteProTaskByTaskId(Long taskId);

    /**
     * 批量删除生产任务
     *
     * @param taskIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProTaskByTaskIds(Long[] taskIds);

    void updateProTaskStatus(@Param("taskId") Long taskId, @Param("status") String status);

    @Select(value = "select t1.*,t3.workorder_code, t3.workorder_id from pro_task t1   inner join pro_workorder t3 on t1.arrange_code = t3.arrange_code  inner join pro_task_workunit t4 on t4.task_id = t1.task_id  ${ew.customSqlSegment}")
    List<ProTaskVo> selectProTaskJoinWorkorder(@Param("ew") QueryWrapper<ProTask> query);


    @Select(value = "select t1.* from pro_task t1 ${ew.customSqlSegment}")
    List<ProTask> selectProTaskJoinProcess(@Param("ew") QueryWrapper<ProTask> query);

    /**
     * 作业面板任务查询
     *
     * @param query
     * @return
     */
    @Select(value = "select t.task_id, t.task_code, t.task_name\n" +
            "\t, t.workstation_id, t.workstation_code, t.workstation_name\n" +
            "\t, t.process_id, t.process_code, t.process_name\n" +
            "\t, t.item_id, t.item_code, t.item_name, t.specification, t.unit_of_measure\n" +
            "\t, ptw.task_workunit_id, ptw.quantity, t.quantity_wait, ptw.quantity_produced, ptw.quantity_changed\n" +
            "\t, t.client_id, t.client_code, t.client_name, t.client_nick, t.is_last_process, ptw.schedule_start_date\n" +
            "\t, t.duration, ptw.schedule_end_date, t.color_code, t.request_date, t.remark\n" +
            "\t, t.attr1, t.attr2, t.attr3, t.attr4, t.create_by\n" +
            "\t, t.create_time, t.update_by, t.update_time, ptw.STATUS,ptw.task_type, ptw.quantity_qualify\n" +
            "\t, ptw.quantity_unqualify, mw.workunit_id, mw.workunit_code, mw.workunit_name, t.arrange_code, proc.is_package\n" +
            "\t, (case ptw.STATUS when 'BEGINNING' then 1 when 'PAUSE' then 2 when 'ERROR_STOP' then 3 when 'PREPARE' then 4 end) statusIndex \n" +
            "from pro_task t\n" +
            "\tleft join pro_task_workunit ptw on ptw.task_id = t.task_id\n" +
            "\tleft join pro_process proc on proc.process_id = t.process_id\n" +
            "\tleft join md_workunit mw on ptw.workunit_id = mw.workunit_id " +
            " ${ew.customSqlSegment}")
    List<ProTask> selectProTaskJoinTaskWorkUnit(@Param("ew") QueryWrapper<ProTask> query);

    @Select(value = "select t1.* from (SELECT t1.arrange_code,t2.workunit_id, t2.schedule_end_date,t1.process_name,t1.process_id\n" +
            "     from pro_task t1 left join pro_task_workunit t2 on t1.task_id = t2.task_id ${ew.customSqlSegment}) t1\n" +
            "INNER JOIN (\n" +
            "    SELECT t2.workunit_id, MAX(t2.schedule_end_date) as max_time\n" +
            "     from pro_task t1 left join pro_task_workunit t2 on t1.task_id = t2.task_id\n" +
            "    GROUP BY t2.workunit_id\n" +
            ") t2 ON t1.workunit_id = t2.workunit_id AND t1.schedule_end_date = t2.max_time")
    List<ProTask> selectEquipmentNewestTask(@Param("ew") QueryWrapper<ProTask> query);

    @Select(value = "select * from pro_task t1 left join pro_task_workorder t2 on t1.task_id = t2.task_id left join pro_arrange t3 on t2.workorder_id = t3.workorder_id ${ew.customSqlSegment}")
    List<ProTask> selectListJoinByQw(@Param("ew") QueryWrapper<ProTask> query);


    @Select(value = "select t1.* from pro_task t1   ${ew.customSqlSegment}")
    List<ProTask> selectListByQw(@Param("ew") QueryWrapper<ProTask> query);

    @Select("select md.workunit_name from pro_task p \n" +
            "LEFT JOIN pro_task_workunit pw on p.task_id=pw.task_id\n" +
            "LEFT JOIN md_workunit md on pw.workunit_id=md.workunit_id where p.task_id=#{taskId}")
    ProTask selectWorkunitTaskId(@Param("taskId") Long taskId);

    @Select("select p.task_id,pw.task_workunit_id,pw.task_workunit_id,pw.status from pro_task p LEFT JOIN pro_task_workunit pw on p.task_id=pw.task_id   ${ew.customSqlSegment}")
    List<ProTask> selectTaskWuListByQw(@Param("ew") QueryWrapper<ProTask> query);
}
