package com.ximai.mes.pro.mapper;

import java.util.List;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.ProProductQrcodeRecord;
import com.ximai.mes.pro.dto.ProProductQrcodeRecordDto;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;

/**
 * 产品序列号打印记录Mapper接口
 *
 * @author generator
 * @date 2024-08-31
 */
public interface ProProductQrcodeRecordMapper extends BaseMapper<ProProductQrcodeRecord>
{
    /**
     * 查询产品序列号打印记录
     *
     * @param recordId 产品序列号打印记录主键
     * @return 产品序列号打印记录
     */
    public ProProductQrcodeRecordDto selectProProductQrcodeRecordByRecordId(Long recordId);

    /**
     * 查询产品序列号打印记录列表
     *
     * @param proProductQrcodeRecord 产品序列号打印记录
     * @return 产品序列号打印记录集合
     */
    public List<ProProductQrcodeRecordDto> selectProProductQrcodeRecordList(ProProductQrcodeRecord proProductQrcodeRecord);

    /**
     * 查询产品序列号打印记录列表
     *
     * @param proProductQrcodeRecordQuery 产品序列号打印记录
     * @return 产品序列号打印记录集合
     */
    @Select("select m.*,item.item_name from pro_product_qrcode_record m left join md_item item on m.item_id = item.item_id ${ew.customSqlSegment}")
    public List<ProProductQrcodeRecordDto> selectDtoListByQw(@Param("ew") QueryWrapper<ProProductQrcodeRecord> proProductQrcodeRecordQuery);

    /**
     * 新增产品序列号打印记录
     *
     * @param proProductQrcodeRecord 产品序列号打印记录
     * @return 结果
     */
    public int insertProProductQrcodeRecord(ProProductQrcodeRecord proProductQrcodeRecord);

    /**
     * 修改产品序列号打印记录
     *
     * @param proProductQrcodeRecord 产品序列号打印记录
     * @return 结果
     */
    public int updateProProductQrcodeRecord(ProProductQrcodeRecord proProductQrcodeRecord);

    /**
     * 删除产品序列号打印记录
     *
     * @param recordId 产品序列号打印记录主键
     * @return 结果
     */
    public int deleteProProductQrcodeRecordByRecordId(Long recordId);

    /**
     * 批量删除产品序列号打印记录
     *
     * @param recordIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProProductQrcodeRecordByRecordIds(Long[] recordIds);
}
