package com.ximai.mes.pro.domain.vo.proWorkOrder;

import cn.hutool.core.text.StrJoiner;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderSoDirective;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderSoSizeItem;
import com.ximai.mes.pro.service.task.IProPackagePrintRecordService;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 工单包装信息结果
 *
 * @author chicheng.li
 * @date 2024-05-15
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WorkorderPackageResult {

    List<WorkorderPackage> packageList;

    List<ProWorkOrderSoDirective> directiveList;

    List<ProWorkOrderSoSizeItem> sizeList;

    PackageType packageType;

    //获取标签SIZE名称
    public String getStandardSize(WorkorderPackage tempPackage){
        Set<String> sizeUnique = new HashSet<String>();
        StrJoiner j2 = StrJoiner.of(",");
        if(tempPackage.getQrcode().startsWith(IProPackagePrintRecordService.BL)){
            tempPackage.getPackageList().forEach(t->{
                if(t.getDistributes()!=null&&t.getDistributes().size()>0){
                    t.getDistributes().stream().filter(t2 -> t2.getSizeId() != null).forEach(t2->{
                        if(!sizeUnique.contains(t2.getSizeId()+"")){
                            this.getSizeList().stream().filter(temp -> temp.getWorkorderSoSizeItemId().equals(t2.getSizeId())).findFirst().ifPresent(temp -> {
                                j2.append(temp.getStandardSize());
                            });
                        }
                        sizeUnique.add(t2.getSizeId()+"");
                    });
                }else if(t.getWorkorderSoSizeItemId()!=null){
                    if(!sizeUnique.contains(t.getWorkorderSoSizeItemId() + "")) {
                        this.getSizeList().stream().filter(temp -> temp.getWorkorderSoSizeItemId().equals(t.getWorkorderSoSizeItemId())).findFirst().ifPresent(temp -> {
                            j2.append(temp.getStandardSize());
                        });
                    }
                    sizeUnique.add(t.getWorkorderSoSizeItemId()+"");
                }
            });
        } else if (tempPackage.getWorkorderSoSizeItemId() == null) {
            if (tempPackage.getDistributes() != null && tempPackage.getDistributes().size() > 0) {
                tempPackage.getDistributes().stream().filter(t -> t.getSizeId() != null).forEach(t -> {
                    this.getSizeList().stream().filter(temp -> temp.getWorkorderSoSizeItemId().equals(t.getSizeId())).findFirst().ifPresent(temp -> {
                        j2.append(temp.getStandardSize());
                    });
                });
            }
        } else {
            this.getSizeList().stream().filter(temp -> temp.getWorkorderSoSizeItemId().equals(tempPackage.getWorkorderSoSizeItemId())).findFirst().ifPresent(temp -> {
                j2.append(temp.getStandardSize());
            });
        }
        return j2.toString();
    }

}
