package com.ximai.mes.pro.domain.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcessDrawing;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionSpecificationSheet;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.mes.pro.dto.productionSolution.ProProductionSolutionProcessDrawingDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * title:
 * author:ZHT
 * date:2024/1/23
 * description:
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ProProductionSolutionVo implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(type = IdType.AUTO)
    private Long productionSolutionId;

    /**
     * 编码
     */
    @ApiModelProperty("编码")
    private String productionSolutionCode;

    /**
     * 名称
     */
    @ApiModelProperty("名称")
    private String productionSolutionName;

    /**
     * 类型
     */
    @ApiModelProperty("类型")
    private String productionSolutionType;

    /**
     * SAP打样工单号
     */
    @ApiModelProperty("SAP打样工单号")
    private String sapPrototypeMakeCode;
    /**
     * 产品ID
     */
    @ApiModelProperty("产品ID")
    private Long itemId;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String itemName;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String itemCode;

    /**
     * 工艺路线ID
     */
    @ApiModelProperty("工艺路线ID")
    private Long routeId;

    /**
     * 工艺路线名称
     */
    @ApiModelProperty("工艺路线名称")
    private String routeName;

    /**
     * 生产用途
     */
    @ApiModelProperty("生产用途")
    private Long usageId;

    /**
     * 生产用途名称
     */
    @ApiModelProperty("生产用途名称")
    private String usageName;

    /**
     * SAP物料编码
     */
    @ApiModelProperty("SAP物料编码")
    private String sapItemCode;

    /**
     * 工厂编码
     */
    @ApiModelProperty("工厂编码")
    private String factoryCode;

    /**
     * 任务清单组键值
     */
    @ApiModelProperty("任务清单组键值")
    private String groupKey;

    /**
     * 组计数器
     */
    @ApiModelProperty("组计数器")
    private String groupCounter;

    /**
     * 物料清单组号
     */
    @ApiModelProperty("物料清单组号")
    private String materialsGroupBill;

    /**
     * 备选物料清单
     */
    @ApiModelProperty("备选物料清单")
    private String alternativeBill;

    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private String status;

    /**
     * 有效起始日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    /**
     * 有效期截止日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date expiryDate;

    /**
     * 最小批量
     */
    private BigDecimal maxLot;

    /**
     * 最大批量
     */
    private BigDecimal minLot;

    /**
     * 创建者
     */
    private String createBy;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新者
     */
    private String updateBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 工程变更
     */
    @ApiModelProperty("工程变更")
    private String ecnCode;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String unitOfMeasure;

    /**
     * 判断条件
     */
    private char updateLog;

    /**
     * SAP用途
     */
    @ApiModelProperty("SAP用途")
    private String sapUsageId;

    /**
     * BOM头信息
     */
    @ApiModelProperty("BOM头信息")
    private ProProductionSolutionBomHeadVo bomHead;

    /**
     * 工序列表
     */
    @ApiModelProperty("工序列表")
    private List<ProProductionSolutionProcessVo> processList;

    /**
     * 规格书
     */
    @ApiModelProperty("规格书")
    private ProProductionSolutionSpecificationSheet specificationSheet;

}
