package com.ximai.mes.pro.domain.task;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 任务工作单元对象 pro_task_workunit
 *
 * @author zht
 * @date 2024-01-23
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProTaskWorkunit extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField
    @ApiModelProperty("生产任务ID")
    private Long taskWorkunitId;

    /**
     * 任务ID
     */
    @Excel(name = "任务ID")
    private Long taskId;

    @TableField(exist = false)
    private List<Long> taskIds;

    @TableField(exist = false)
    private String taskWorkunitCode;

    @TableField(exist = false)
    private Long duration;
    /**
     * 顺序号
     */
    @Excel(name = "顺序号")
    private Long idx;

    /**
     * 工作单元ID
     */
    @Excel(name = "工作单元ID")
    @ApiModelProperty("工作单元ID")
    private Long workunitId;


    private Long sourceTaskWorkunidId;
    /**
     * 单位
     */
    @Excel(name = "单位")
    private String unitOfMeasure;

    /**
     * 排产数量
     */
    @Excel(name = "排产数量")
    @ApiModelProperty("排产数量")
    private BigDecimal quantity;

    /**
     * 已生产数量
     */
    @Excel(name = "已生产数量")
    @ApiModelProperty("已生产数量")
    private BigDecimal quantityProduced;

    /**
     * 合格品数量
     */
    @Excel(name = "合格品数量")
    private BigDecimal quantityQualify;

    /**
     * 不良品数量
     */
    @Excel(name = "不良品数量")
    private BigDecimal quantityUnqualify;

    /**
     * 调整数量
     */
    @Excel(name = "调整数量")
    private BigDecimal quantityChanged;

    /**
     * 生产任务状态
     */
    @ApiModelProperty("状态")
    private String status;

    private Integer taskType;
    /**
     * 预计开始时间
     */
    @ApiModelProperty("计划开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleStartDate;

    /**
     * 预计结束时间
     */
    @ApiModelProperty("计划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleEndDate;

    @ApiModelProperty("备注")
    private String remark;

    @TableField(exist = false)
    private Long processId;

    @ApiModelProperty("工序名")
    @TableField(exist = false)
    private String processName;

    @TableField(exist = false)
    @ApiModelProperty("作业单元编码")
    private String workunitCode;

    @TableField(exist = false)
    @ApiModelProperty("作业单元名称")
    private String workunitName;

    @TableField(exist = false)
    @ApiModelProperty("任务编码")
    private String taskCode;
//
//    @TableField(exist = false)
//    private int lastAssistProcess;

    @TableField(exist = false)
    @ApiModelProperty("产品物料编码")
    @Excel(name = "产品物料编码")
    private String itemCode;

    @TableField(exist = false)
    @ApiModelProperty("产品物料名称")
    @Excel(name = "产品物料名称")
    private String itemName;

    @TableField(exist = false)
    @ApiModelProperty("规格型号")
    @Excel(name = "规格型号")
    private String specification;

    @TableField(exist = false)
    @ApiModelProperty("工作中心名称")
    @Excel(name = "工作中心名称")
    private String workstationName;

    @ApiModelProperty("工作中心ID")
    @Excel(name = "工作中心ID")
    private Long workstationId;

    @ApiModelProperty("工作中心ID")
    @Excel(name = "工作中心ID")
    private String workstationCode;

    @TableField(exist = false)
    @ApiModelProperty("编排单号")
    private String arrangeCode;

    @TableField(exist = false)
    @ApiModelProperty("工单编号")
    private String workorderCode;

    private int percent;
}
