package com.ximai.mes.pro.domain.proWorkOrder;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.TreeEntity;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.pro.domain.task.ProTaskWorkunit;
import com.ximai.mes.pro.domain.vo.ProTaskVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 生产工单对象 pro_workorder
 *
 * @date 2022-05-15
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ProWorkorder extends TreeEntity {
    private static final long serialVersionUID = 1L;

    public ProWorkorder(Long workorderId, String status) {
        this.workorderId = workorderId;
        this.status = status;
    }

    public ProWorkorder(Long workorderId, String workorderCode, String arrangeCode, List<ProTaskVo> taskVos, List<ProTaskWorkunit> proTaskWorkunits) {
        this.workorderCode = workorderCode;
        this.workorderId = workorderId;
        this.arrangeCode = arrangeCode;
        this.taskVos = taskVos;
        this.proTaskWorkunits = proTaskWorkunits;
    }


    /**
     * 工单ID
     */
    @TableId
    private Long workorderId;

    private String salesVoucher;

    private String salesVoucherItem;

    /**
     * 工单编码
     */
    @Excel(name = "工单编码")
    private String workorderCode;

    private String startSerial;
    private String endSerial;
    /**
     * 工单名称
     */
    @Excel(name = "工单名称")
    private String workorderName;

    /**
     * 工单类型
     */
    @Excel(name = "工单类型")
    private String workorderType;

    /**
     * 来源类型
     */
    @Excel(name = "来源类型")
    private String orderSource;

    /**
     * 来源单据
     */
    @Excel(name = "来源单据")
    @ApiModelProperty("来源单据")
    private String sourceCode;

    /**
     * 产品ID
     */
    @Excel(name = "产品ID")
    private Long productId;


    /**
     * 是否急单
     */
    @Excel(name = "是否急单")
    private String  rushOrder;

    /**
     * 产品编号
     */
    @Excel(name = "产品编号")
    private String productCode;

    /**
     * 产品名称
     */
    @Excel(name = "产品名称")
    private String productName;
    /**
     * 规格型号
     */
    @Excel(name = "规格型号")
    private String productSpc;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String unitOfMeasure;

    /**
     * 编排单号
     */
    @ApiModelProperty("编排单号")
    private String arrangeCode;

    /**
     * 批次号
     */
    @Excel(name = "批次号")
    private String batchCode;

    /**
     * 生产数量
     */
    @Excel(name = "生产数量")
    @ApiModelProperty("工单数量")
    private BigDecimal quantity;

    /**
     * 已生产数量
     */
    @ApiModelProperty("已生产数量")
    private BigDecimal quantityProduced;

    @ApiModelProperty("合格数量")
    private BigDecimal quantityQualify;

    @ApiModelProperty("不合格数量")
    private BigDecimal quantityUnqualify;

    /**
     * 调整数量
     */
    @Excel(name = "调整数量")
    private BigDecimal quantityChanged;

    /**
     * 已排产数量
     */
    @ApiModelProperty("已排产数量")
    private BigDecimal quantityScheduled;

    /**
     * 客户ID
     */
    @Excel(name = "客户ID")
    private Long clientId;

    /**
     * 客户编码
     */
    @Excel(name = "客户编码")
    private String clientCode;

    /**
     * 客户名称
     */
    @Excel(name = "客户名称")
    private String clientName;

    /**
     * 供应商ID
     */
    @Excel(name = "供应商ID")
    private Long vendorId;

    /**
     * 供应商编号
     */
    @Excel(name = "供应商编号")
    private String vendorCode;

    /**
     * 供应商名称
     */
    @Excel(name = "供应商名称")
    private String vendorName;


    /**
     * 需求日期 -> 完工时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "需求日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date requestDate;

    /**
     * 完成时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "完成时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date finishDate;

    /**
     * 单据状态
     */
    @Excel(name = "单据状态")
    private String status;

    @ApiModelProperty("生产版本ID")
    private Long productionSolutionId;

    @ApiModelProperty("生产版本编码")
    private String productionSolutionCode;

    @ApiModelProperty("生产版本名称")
    private String productionSolutionName;

    /**
     * 工厂编码
     */
    @Excel(name = "工厂编码")
    private Long factoryCode;

    /**
     * 订单开始日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "订单开始日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startDate;

    /**
     * 生产主管
     */
    @Excel(name = "生产主管")
    private String productionManagerId;

    /**
     * 库存地点
     */
    @Excel(name = "库存地点")
    private String storageLocation;

    /**
     * 派工倍数
     */
    @Excel(name = "派工倍数")
    private String dispatchMultiple;

    /**
     * 排版行数
     */
    @Excel(name = "排版行数")
    private String rowNum;

    /**
     * 单重
     */
    @Excel(name = "单重")
    private BigDecimal singleWeight;

    /**
     * 厚度(丝)
     */
    @Excel(name = "厚度(丝)")
    private BigDecimal thickness;

    /**
     * 物料清单
     */
    @Excel(name = "物料清单")
    private String materialsGroupBill;

    /**
     * 备选物料清单
     */
    @Excel(name = "备选物料清单")
    private String alternativeBill;

    /**
     * sap物料号
     */
    private String sapItemCode;

    @ApiModelProperty("批次序列号")
    private Integer batchSerial;

    /**
     * ep物料号
     */
    private String epItemCode;

    @ApiModelProperty("包装数量")
    private BigDecimal packNum;

    @ApiModelProperty("包装类型，0:无，1：size 2：指令")
    private String packType;

    @ApiModelProperty("包装单位")
    private String packUnitOfMeasure;

    @ApiModelProperty("LOSS数是否单独包装，Y：是，N：否")
    private String lossIndividuallyWrap;

    @ApiModelProperty("使用包装数量")
    private Integer usagePackNum;

    @ApiModelProperty("使用装箱数量")
    private Integer usageEncasementNum;

    @ApiModelProperty("合并包装，1：是，0：否")
    private Integer mergePack;


    @TableField(exist = false)
    private Date combinationStartTime;

    //产品分类
    @TableField(exist = false)
    private String itemTypeName;

    @TableField(exist = false)
    private Long itemTypeId;

    @TableField(exist = false)
    private double processingRatio;

    @TableField(exist = false)
    private Double feedBackedQuantity;

    @TableField(exist = false)
    private Long taskId;

    @TableField(exist = false)
    private String combinationCode;

    @TableField(exist = false)
    private String workorderIds;

    @TableField(exist = false)
    private List<ProTask> tasks;

    @TableField(exist = false)
    private List<ProTaskVo> taskVos;

    @TableField(exist = false)
    private List<ProTaskWorkunit> proTaskWorkunits;

}
