package com.ximai.mes.pro.domain;

import javax.validation.constraints.Size;
import javax.validation.constraints.NotNull;

import java.util.Date;

import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Length;

/**
* 生产用途
* @TableName pro_usage
*/
public class ProUsage extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
    * 主键id
    */
    @NotNull(message="[主键id]不能为空")
    @ApiModelProperty("主键id")
    private Integer usageId;
    /**
    * 编码
    */
    @Size(max= 64,message="编码长度不能超过64")
    @ApiModelProperty("编码")
    @Length(max= 64,message="编码长度不能超过64")
    @Excel(name = "用途编码")
    private String usageCode;
    /**
    * 名称
    */
    @Size(max= 255,message="编码长度不能超过255")
    @ApiModelProperty("名称")
    @Length(max= 255,message="编码长度不能超过255")
    @Excel(name = "用途名称")
    private String usageName;
    /**
    * 备注
    */
    @Size(max= 500,message="编码长度不能超过500")
    @ApiModelProperty("备注")
    @Length(max= 500,message="编码长度不能超过500")
    @Excel(name = "备注")
    private String remark;
    /**
    * 是否启用
    */
    @ApiModelProperty("是否启用")
    @Excel(name = "是否启用")
    private String enableFlag;
    /**
    * 创建者
    */
    @Size(max= 64,message="编码长度不能超过64")
    @ApiModelProperty("创建者")
    @Length(max= 64,message="编码长度不能超过64")
    @Excel(name = "创建者")
    private String createBy;
    /**
    * 创建日期
    */
    @ApiModelProperty("创建日期")
    @Excel(name = "创建日期")
    private Date createTime;
    /**
    * 更新者
    */
    @Size(max= 64,message="编码长度不能超过64")
    @ApiModelProperty("更新者")
    @Length(max= 64,message="编码长度不能超过64")
    @Excel(name = "更新者")
    private String updateBy;
    /**
    * 更新日期
    */
    @ApiModelProperty("更新日期")
    @Excel(name = "更新日期")
    private Date updateTime;

    public Integer getUsageId() {
        return usageId;
    }

    public void setUsageId(Integer usageId) {
        this.usageId = usageId;
    }

    public String getUsageCode() {
        return usageCode;
    }

    public void setUsageCode(String usageCode) {
        this.usageCode = usageCode;
    }

    public String getUsageName() {
        return usageName;
    }

    public void setUsageName(String usageName) {
        this.usageName = usageName;
    }

    @Override
    public String getRemark() {
        return remark;
    }

    @Override
    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getEnableFlag() {
        return enableFlag;
    }

    public void setEnableFlag(String enableFlag) {
        this.enableFlag = enableFlag;
    }

    @Override
    public String getCreateBy() {
        return createBy;
    }

    @Override
    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getUpdateBy() {
        return updateBy;
    }

    @Override
    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}
