package com.ximai.mes.pro.controller.task;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.pro.domain.task.ProTaskWorkorder;
import com.ximai.mes.pro.domain.vo.ProProcessTaskVo;
import com.ximai.mes.pro.domain.vo.ProTaskWorkorderReportFormListVo;
import com.ximai.mes.pro.domain.vo.feedbackTaskVo;
import com.ximai.mes.pro.service.IProFeedbackService;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderProcessService;
import com.ximai.mes.pro.service.task.IProTaskWorkorderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 任务合并工单Controller
 *
 * @author zht
 * @date 2024-01-23
 */
@RestController
@RequestMapping("/mes:pro/taskWorkorder")
public class ProTaskWorkorderController extends BaseController {
    @Autowired
    private IProTaskWorkorderService proTaskWorkorderService;


    @Autowired
    private IProWorkOrderProcessService proWorkOrderProcessService;


    @Autowired
    private IProFeedbackService proFeedbackService;


    /**
     * 查询任务合并工单列表
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:taskWorkorder:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProTaskWorkorder proTaskWorkorder) {
        startPage();
        List<ProTaskWorkorder> list = proTaskWorkorderService.selectProTaskWorkorderList(proTaskWorkorder);
        return getDataTable(list);
    }

    /**
     * 导出任务合并工单列表
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:taskWorkorder:export')")
    @Log(title = "任务合并工单", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProTaskWorkorder proTaskWorkorder) {
        List<ProTaskWorkorder> list = proTaskWorkorderService.selectProTaskWorkorderList(proTaskWorkorder);
        ExcelUtil<ProTaskWorkorder> util = new ExcelUtil<ProTaskWorkorder>(ProTaskWorkorder.class);
        util.exportExcel(response, list, "任务合并工单数据");
    }

    /**
     * 获取任务合并工单详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:taskWorkorder:query')")
    @GetMapping(value = "/{taskWorkorderId}")
    public AjaxResult getInfo(@PathVariable("taskWorkorderId") Long taskWorkorderId) {
        return AjaxResult.success(proTaskWorkorderService.selectProTaskWorkorderByTaskWorkorderId(taskWorkorderId));
    }

    /**
     * 新增任务合并工单
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:taskWorkorder:add')")
    @Log(title = "任务合并工单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProTaskWorkorder proTaskWorkorder) {
        return toAjax(proTaskWorkorderService.insertProTaskWorkorder(proTaskWorkorder));
    }

    /**
     * 修改任务合并工单
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:taskWorkorder:edit')")
    @Log(title = "任务合并工单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProTaskWorkorder proTaskWorkorder) {
        return toAjax(proTaskWorkorderService.updateProTaskWorkorder(proTaskWorkorder));
    }

    /**
     * 删除任务合并工单
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:taskWorkorder:remove')")
    @Log(title = "任务合并工单", businessType = BusinessType.DELETE)
    @DeleteMapping("/{taskWorkorderIds}")
    public AjaxResult remove(@PathVariable Long[] taskWorkorderIds) {
        return toAjax(proTaskWorkorderService.deleteProTaskWorkorderByTaskWorkorderIds(taskWorkorderIds));
    }

    /**
     * 生产报表
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:taskWorkorder:list')")
    @GetMapping("/reportformList")
    public TableDataInfo reportFormList(ProTaskWorkorderReportFormListVo ProTaskWorkorderReportFormListVo) {
        startPage();
        List<ProTaskWorkorderReportFormListVo> list = proTaskWorkorderService.selectProTaskWorkorderReportFormList(ProTaskWorkorderReportFormListVo);
        return getDataTable(list);
    }

    /**
     * 工序数据展示
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:taskWorkorder:list')")
    @GetMapping("/processList")
    public TableDataInfo procesList(ProProcessTaskVo proProcessTaskVo) {
        startPage();
        List<ProProcessTaskVo> list = proWorkOrderProcessService.selectprocessReportFormList(proProcessTaskVo);
        return getDataTable(list);
    }

    /**
     * 报工信息展示
     */

    @PreAuthorize("@ss.hasPermi('mes:pro:taskWorkorder:list')")
    @GetMapping("/feedbackList")
    public TableDataInfo feedbackList(feedbackTaskVo feedbackTaskVo) {
        startPage();
        List<feedbackTaskVo> list = proFeedbackService.selectProFeedbackreport(feedbackTaskVo);
        return getDataTable(list);


    }


}
