package com.ximai.mes.pro.controller.task;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.pro.domain.task.ProTaskAssistProcess;
import com.ximai.mes.pro.service.task.IProTaskAssistProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 工序任务外协关系Controller
 *
 * @author generator
 * @date 2024-03-29
 */
@RestController
@RequestMapping("/md/assistprocess")
public class ProTaskAssistProcessController extends BaseController {

    @Autowired
    private IProTaskAssistProcessService proTaskAssistProcessService;

    /**
     * 查询工序任务外协关系列表
     */
    @GetMapping("/list")
    public TableDataInfo list(ProTaskAssistProcess proTaskAssistProcess) {
        startPage();
        List<ProTaskAssistProcess> list = proTaskAssistProcessService.selectListByObj(proTaskAssistProcess);
        return getDataTable(list);
    }


    /**
     * 查询工序任务外协关系列表
     */
    @GetMapping("/getAssistProcesslist")
    public TableDataInfo getAssistProcesslist(ProTaskAssistProcess proTaskAssistProcess) {
        startPage();
        List<ProTaskAssistProcess> list = proTaskAssistProcessService.getAssistProcesslist(proTaskAssistProcess);
        return getDataTable(list);
    }


    /**
     * 查询工序任务外协关系列表
     */
    @GetMapping("/feedbackinfo")
    public TableDataInfo feedbackinfo(ProTaskAssistProcess proTaskAssistProcess) {
        startPage();
        List<ProTaskAssistProcess> list = proTaskAssistProcessService.getAssistProcesslist(proTaskAssistProcess);
        return getDataTable(list);
    }


    /**
     * 查询工序任务外协关系列表
     */
    @GetMapping("/listUnreportedFeedback")
    public TableDataInfo listUnreportedFeedback(ProTaskAssistProcess proTaskAssistProcess) {
        startPage();
        return getDataTable(proTaskAssistProcessService.listUnreportedFeedback(proTaskAssistProcess));
    }

    /**
     * 导出工序任务外协关系列表
     */
    @Log(title = "工序任务外协关系", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProTaskAssistProcess proTaskAssistProcess) {
        List<ProTaskAssistProcess> list = proTaskAssistProcessService.selectListByObj(proTaskAssistProcess);
        ExcelUtil<ProTaskAssistProcess> util = new ExcelUtil<ProTaskAssistProcess>(ProTaskAssistProcess.class);
        util.exportExcel(response, list, "工序任务外协关系数据");
    }


    /**
     * 获取工序任务外协关系详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(proTaskAssistProcessService.selectProTaskAssistProcessById(id));
    }

    /**
     * 新增工序任务外协关系
     */
    @Log(title = "工序任务外协关系", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProTaskAssistProcess proTaskAssistProcess) {
        return toAjax(proTaskAssistProcessService.insertProTaskAssistProcess(proTaskAssistProcess));
    }


    /**
     * 修改工序任务外协关系
     */
    @Log(title = "工序任务外协关系", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProTaskAssistProcess proTaskAssistProcess) {
        return toAjax(proTaskAssistProcessService.updateProTaskAssistprocess(proTaskAssistProcess));
    }


    /**
     * 删除工序任务外协关系
     */
    @Log(title = "工序任务外协关系", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(proTaskAssistProcessService.deleteProTaskAssistProcessByIds(ids));
    }
}
