package com.ximai.mes.pro.controller.task;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.task.ProFdQrcodePrintRecord;
import com.ximai.mes.pro.service.task.IProFdQrcodePrintRecordService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 报工打印二维码记录表Controller
 *
 * @author generator
 * @date 2024-03-19
 */
@RestController
@RequestMapping("/pro/qrcode")
public class ProFdQrcodePrintRecordController extends BaseController
{
    @Autowired
    private IProFdQrcodePrintRecordService proFdQrcodePrintRecordService;

    /**
     * 查询报工打印二维码记录表列表
     */
    @PreAuthorize("@ss.hasPermi('pro:record:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProFdQrcodePrintRecord proFdQrcodePrintRecord)
    {
        startPage();
        List<ProFdQrcodePrintRecord> list = proFdQrcodePrintRecordService.selectProFdQrcodePrintRecordList(proFdQrcodePrintRecord);
        return getDataTable(list);
    }

    /**
     * 导出报工打印二维码记录表列表
     */
    @PreAuthorize("@ss.hasPermi('pro:record:export')")
    @Log(title = "报工打印二维码记录表", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProFdQrcodePrintRecord proFdQrcodePrintRecord)
    {
        List<ProFdQrcodePrintRecord> list = proFdQrcodePrintRecordService.selectProFdQrcodePrintRecordList(proFdQrcodePrintRecord);
        ExcelUtil<ProFdQrcodePrintRecord> util = new ExcelUtil<ProFdQrcodePrintRecord>(ProFdQrcodePrintRecord.class);
        util.exportExcel(response, list, "报工打印二维码记录表数据");
    }

    /**
     * 获取报工打印二维码记录表详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:record:query')")
    @GetMapping(value = "/{recordId}")
    public AjaxResult getInfo(@PathVariable("recordId") Long recordId)
    {
        return AjaxResult.success(proFdQrcodePrintRecordService.selectProFdQrcodePrintRecordByRecordId(recordId));
    }

    /**
     * 新增报工打印二维码记录表
     */
    @PreAuthorize("@ss.hasPermi('pro:record:add')")
    @Log(title = "报工打印二维码记录表", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProFdQrcodePrintRecord proFdQrcodePrintRecord)
    {
        return toAjax(proFdQrcodePrintRecordService.insertProFdQrcodePrintRecord(proFdQrcodePrintRecord));
    }

    /**
     * 修改报工打印二维码记录表
     */
    @PreAuthorize("@ss.hasPermi('pro:record:edit')")
    @Log(title = "报工打印二维码记录表", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProFdQrcodePrintRecord proFdQrcodePrintRecord)
    {
        return toAjax(proFdQrcodePrintRecordService.updateProFdQrcodePrintRecord(proFdQrcodePrintRecord));
    }

    /**
     * 删除报工打印二维码记录表
     */
    @PreAuthorize("@ss.hasPermi('pro:record:remove')")
    @Log(title = "报工打印二维码记录表", businessType = BusinessType.DELETE)
	@DeleteMapping("/{recordIds}")
    public AjaxResult remove(@PathVariable Long[] recordIds)
    {
        return toAjax(proFdQrcodePrintRecordService.deleteProFdQrcodePrintRecordByRecordIds(recordIds));
    }
}
