package com.ximai.mes.pro.controller.prototypeRequest;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.prototypeRequest.ProPrototypeRequestProcessTool;
import com.ximai.mes.pro.service.prototypeRequest.IProPrototypeRequestProcessToolService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 打样申请工序工装夹具Controller
 *
 * @author generator
 * @date 2024-01-27
 */
@RestController
@RequestMapping("/mes/pro/prototypeRequestTool")
public class ProPrototypeRequestProcessToolController extends BaseController
{
    @Autowired
    private IProPrototypeRequestProcessToolService proPrototypeRequestProcessToolService;

    /**
     * 查询打样申请工序工装夹具列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestTool:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProPrototypeRequestProcessTool proPrototypeRequestProcessTool)
    {
        startPage();
        List<ProPrototypeRequestProcessTool> list = proPrototypeRequestProcessToolService.selectProPrototypeRequestProcessToolList(proPrototypeRequestProcessTool);
        return getDataTable(list);
    }

    /**
     * 导出打样申请工序工装夹具列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestTool:export')")
    @Log(title = "打样申请工序工装夹具", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProPrototypeRequestProcessTool proPrototypeRequestProcessTool)
    {
        List<ProPrototypeRequestProcessTool> list = proPrototypeRequestProcessToolService.selectProPrototypeRequestProcessToolList(proPrototypeRequestProcessTool);
        ExcelUtil<ProPrototypeRequestProcessTool> util = new ExcelUtil<ProPrototypeRequestProcessTool>(ProPrototypeRequestProcessTool.class);
        util.exportExcel(response, list, "打样申请工序工装夹具数据");
    }

    /**
     * 获取打样申请工序工装夹具详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestTool:query')")
    @GetMapping(value = "/{prototypeRequestProcessToolId}")
    public AjaxResult getInfo(@PathVariable("prototypeRequestProcessToolId") Long prototypeRequestProcessToolId)
    {
        return AjaxResult.success(proPrototypeRequestProcessToolService.selectProPrototypeRequestProcessToolByPrototypeRequestProcessToolId(prototypeRequestProcessToolId));
    }

    /**
     * 新增打样申请工序工装夹具
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestTool:add')")
    @Log(title = "打样申请工序工装夹具", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProPrototypeRequestProcessTool proPrototypeRequestProcessTool)
    {
        return toAjax(proPrototypeRequestProcessToolService.insertProPrototypeRequestProcessTool(proPrototypeRequestProcessTool));
    }

    /**
     * 修改打样申请工序工装夹具
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestTool:edit')")
    @Log(title = "打样申请工序工装夹具", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProPrototypeRequestProcessTool proPrototypeRequestProcessTool)
    {
        return toAjax(proPrototypeRequestProcessToolService.updateProPrototypeRequestProcessTool(proPrototypeRequestProcessTool));
    }

    /**
     * 删除打样申请工序工装夹具
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestTool:remove')")
    @Log(title = "打样申请工序工装夹具", businessType = BusinessType.DELETE)
	@DeleteMapping("/{prototypeRequestProcessToolIds}")
    public AjaxResult remove(@PathVariable Long[] prototypeRequestProcessToolIds)
    {
        return toAjax(proPrototypeRequestProcessToolService.deleteProPrototypeRequestProcessToolByPrototypeRequestProcessToolIds(prototypeRequestProcessToolIds));
    }
}
