package com.ximai.mes.pro.controller.prototypeRequest;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.prototypeRequest.ProPrototypeRequestProcessQcindex;
import com.ximai.mes.pro.service.prototypeRequest.IProPrototypeRequestProcessQcindexService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 打样申请工序检验项Controller
 *
 * @author generator
 * @date 2024-01-27
 */
@RestController
@RequestMapping("/mes/pro/prototypeRequestQcindex")
public class ProPrototypeRequestProcessQcindexController extends BaseController
{
    @Autowired
    private IProPrototypeRequestProcessQcindexService proPrototypeRequestProcessQcindexService;

    /**
     * 查询打样申请工序检验项列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestQcindex:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProPrototypeRequestProcessQcindex proPrototypeRequestProcessQcindex)
    {
        startPage();
        List<ProPrototypeRequestProcessQcindex> list = proPrototypeRequestProcessQcindexService.selectProPrototypeRequestProcessQcindexList(proPrototypeRequestProcessQcindex);
        return getDataTable(list);
    }

    /**
     * 导出打样申请工序检验项列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestQcindex:export')")
    @Log(title = "打样申请工序检验项", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProPrototypeRequestProcessQcindex proPrototypeRequestProcessQcindex)
    {
        List<ProPrototypeRequestProcessQcindex> list = proPrototypeRequestProcessQcindexService.selectProPrototypeRequestProcessQcindexList(proPrototypeRequestProcessQcindex);
        ExcelUtil<ProPrototypeRequestProcessQcindex> util = new ExcelUtil<ProPrototypeRequestProcessQcindex>(ProPrototypeRequestProcessQcindex.class);
        util.exportExcel(response, list, "打样申请工序检验项数据");
    }

    /**
     * 获取打样申请工序检验项详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestQcindex:query')")
    @GetMapping(value = "/{prototypeRequestProcessQcindexId}")
    public AjaxResult getInfo(@PathVariable("prototypeRequestProcessQcindexId") Long prototypeRequestProcessQcindexId)
    {
        return AjaxResult.success(proPrototypeRequestProcessQcindexService.selectProPrototypeRequestProcessQcindexByPrototypeRequestProcessQcindexId(prototypeRequestProcessQcindexId));
    }

    /**
     * 新增打样申请工序检验项
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestQcindex:add')")
    @Log(title = "打样申请工序检验项", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProPrototypeRequestProcessQcindex proPrototypeRequestProcessQcindex)
    {
        return toAjax(proPrototypeRequestProcessQcindexService.insertProPrototypeRequestProcessQcindex(proPrototypeRequestProcessQcindex));
    }

    /**
     * 修改打样申请工序检验项
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestQcindex:edit')")
    @Log(title = "打样申请工序检验项", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProPrototypeRequestProcessQcindex proPrototypeRequestProcessQcindex)
    {
        return toAjax(proPrototypeRequestProcessQcindexService.updateProPrototypeRequestProcessQcindex(proPrototypeRequestProcessQcindex));
    }

    /**
     * 删除打样申请工序检验项
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestQcindex:remove')")
    @Log(title = "打样申请工序检验项", businessType = BusinessType.DELETE)
	@DeleteMapping("/{prototypeRequestProcessQcindexIds}")
    public AjaxResult remove(@PathVariable Long[] prototypeRequestProcessQcindexIds)
    {
        return toAjax(proPrototypeRequestProcessQcindexService.deleteProPrototypeRequestProcessQcindexByPrototypeRequestProcessQcindexIds(prototypeRequestProcessQcindexIds));
    }
}
