package com.ximai.mes.pro.controller.prototypeRequest;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.pro.domain.vo.ProPrototypeRequestVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.prototypeRequest.ProPrototypeRequest;
import com.ximai.mes.pro.service.prototypeRequest.IProPrototypeRequestService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 打样申请Controller
 *
 * @author zht
 * @date 2024-01-18
 */
@RestController
@RequestMapping("/mes/pro/prototypeRequest")
public class ProPrototypeRequestController extends BaseController
{
    @Autowired
    private IProPrototypeRequestService proPrototypeRequestService;

    /**
     * 查询打样申请列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequest:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProPrototypeRequest proPrototypeRequest)
    {
        startPage();
        List<ProPrototypeRequest> list = proPrototypeRequestService.selectProPrototypeRequestList(proPrototypeRequest);
        return getDataTable(list);
    }

    /**
     * 导出打样申请列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequest:export')")
    @Log(title = "打样申请", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProPrototypeRequest proPrototypeRequest)
    {
        List<ProPrototypeRequest> list = proPrototypeRequestService.selectProPrototypeRequestList(proPrototypeRequest);
        ExcelUtil<ProPrototypeRequest> util = new ExcelUtil<ProPrototypeRequest>(ProPrototypeRequest.class);
        util.exportExcel(response, list, "打样申请数据");
    }

    /**
     * 获取打样申请详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequest:query')")
    @GetMapping(value = "/{prototypeRequestId}")
    public AjaxResult getInfo(@PathVariable("prototypeRequestId") Long prototypeRequestId)
    {
        return AjaxResult.success(proPrototypeRequestService.selectProPrototypeRequestByPrototypeRequestId(prototypeRequestId));
    }

    /**
     * 新增打样申请
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequest:add')")
    @Log(title = "打样申请", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProPrototypeRequestVo ProPrototypeRequestVo)
    {
//        getUsername();
//        getLoginUser()
        return toAjax(proPrototypeRequestService.insertProPrototypeRequest(ProPrototypeRequestVo));
    }

    /**
     * 修改打样申请
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequest:edit')")
    @Log(title = "打样申请", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProPrototypeRequestVo proPrototypeRequest)
    {
        return toAjax(proPrototypeRequestService.updateProPrototypeRequest(proPrototypeRequest));
    }

    /**
     * 删除打样申请
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequest:remove')")
    @Log(title = "打样申请", businessType = BusinessType.DELETE)
	@DeleteMapping("/{prototypeRequestIds}")
    public AjaxResult remove(@PathVariable Long[] prototypeRequestIds)
    {
        return toAjax(proPrototypeRequestService.deleteProPrototypeRequestByPrototypeRequestIds(prototypeRequestIds));
    }

    /** 状态修改 */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequest:edit')")
    @Log(title = "打样申请", businessType = BusinessType.UPDATE)
    @PutMapping("/modifyState")
    public AjaxResult editStatus(@RequestBody ProPrototypeRequest proPrototypeRequest)
    {
        return toAjax(proPrototypeRequestService.updateProPrototypeRequestStatus(proPrototypeRequest));
    }
}
