package com.ximai.mes.pro.controller.prototypeMake;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.pro.domain.prototypeRequest.ProPrototypeRequest;
import com.ximai.mes.pro.domain.vo.ProPrototypeMakeVo;
import com.ximai.mes.pro.mapper.prototypeRequest.ProPrototypeRequestMapper;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMake;
import com.ximai.mes.pro.service.prototypeMake.IProPrototypeMakeService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 样品制作单Controller
 *
 * @author zht
 * @date 2024-01-20
 */
@RestController
@RequestMapping("/mes/pro/prototypeMake")
public class ProPrototypeMakeController extends BaseController
{
    @Autowired
    private IProPrototypeMakeService proPrototypeMakeService;
    @Autowired
    private ProPrototypeRequestMapper proPrototypeRequestMapper;

    /**
     * 查询样品制作单列表
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:prototypeMake:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProPrototypeMake proPrototypeMake)
    {
        startPage();
        List<ProPrototypeMakeVo> list = proPrototypeMakeService.selectProPrototypeMakeList(proPrototypeMake);
        List<ProPrototypeMakeVo> listVo = new ArrayList<ProPrototypeMakeVo>();
        List<Long> requestIds = list.stream().map(s->{return s.getPrototypeRequestId();}).collect(Collectors.toList());
        if(requestIds.size()!=0){
            Map<Long,ProPrototypeRequest> tempMapping = proPrototypeRequestMapper.selectBatchIds(requestIds).stream().collect(Collectors.toMap(s->s.getPrototypeRequestId(),s->s));
            list.forEach(s->{
                ProPrototypeMakeVo vo = new ProPrototypeMakeVo();
                BeanUtil.copyProperties(s, vo);
                if(tempMapping.containsKey(vo.getPrototypeRequestId())){
                    vo.setPlannedFinishDate(tempMapping.get(vo.getPrototypeRequestId()).getPlannedFinishDate());
                    vo.setPlannedLayoutDate(tempMapping.get(vo.getPrototypeRequestId()).getPlannedLayoutDate());
                }
                listVo.add(vo);
            });
        }
        TableDataInfo tableDataInfo =  getDataTable(list);
        tableDataInfo.setRows(listVo);
        return tableDataInfo;
    }


    /**
     * 导出样品制作单列表
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:prototypeMake:export')")
    @Log(title = "样品制作单", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProPrototypeMake proPrototypeMake)
    {
        List<ProPrototypeMakeVo> list = proPrototypeMakeService.selectProPrototypeMakeList(proPrototypeMake);
        ExcelUtil<ProPrototypeMakeVo> util = new ExcelUtil<ProPrototypeMakeVo>(ProPrototypeMakeVo.class);
        util.exportExcel(response, list, "样品制作单数据");
    }

    /**
     * 获取样品制作单详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:prototypeMake:query')")
    @GetMapping(value = "/{prototypeMakeId}")
    public AjaxResult getInfo(@PathVariable("prototypeMakeId") Long prototypeMakeId)
    {
        return AjaxResult.success(proPrototypeMakeService.selectProPrototypeMakeByPrototypeMakeId(prototypeMakeId));
    }

    /**
     * 新增样品制作单
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:prototypeMake:add')")
    @Log(title = "样品制作单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProPrototypeMakeVo proPrototypeMakeVo)
    {
        return toAjax(proPrototypeMakeService.insertProPrototypeMake(proPrototypeMakeVo));
    }

    /**
     * 修改样品制作单
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:prototypeMake:edit')")
    @Log(title = "样品制作单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProPrototypeMakeVo proPrototypeMake)
    {
        return toAjax(proPrototypeMakeService.updateProPrototypeMake(proPrototypeMake));
    }

    /**
     * 删除样品制作单
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:prototypeMake:remove')")
    @Log(title = "样品制作单", businessType = BusinessType.DELETE)
	@DeleteMapping("/{prototypeMakeIds}")
    public AjaxResult remove(@PathVariable Long[] prototypeMakeIds)
    {
        return toAjax(proPrototypeMakeService.deleteProPrototypeMakeByPrototypeMakeIds(prototypeMakeIds));
    }

    /** 状态修改 */
    @PreAuthorize("@ss.hasPermi('mes:pro:prototypeMake:edit')")
    @Log(title = "样品制作单", businessType = BusinessType.UPDATE)
    @PutMapping("/modifyState")
    public AjaxResult editStatus(@RequestBody ProPrototypeMake proPrototypeMake)
    {
        return toAjax(proPrototypeMakeService.updateProPrototypeMakeStatus(proPrototypeMake));
    }
}
