package com.ximai.mes.pro.controller.productionSolution;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionSpecificationSheet;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionSpecificationSheetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 生产方案规格书Controller
 *
 * @author zht
 * @date 2024-03-23
 */
@RestController
@RequestMapping("/pro/specificationSheet")
public class ProProductionSolutionSpecificationSheetController extends BaseController {
    @Autowired
    private IProProductionSolutionSpecificationSheetService proProductionSolutionSpecificationSheetService;

    /**
     * 查询生产方案规格书列表
     */
    @PreAuthorize("@ss.hasPermi('pro:specificationSheet:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProProductionSolutionSpecificationSheet proProductionSolutionSpecificationSheet) {
        startPage();
        List<ProProductionSolutionSpecificationSheet> list = proProductionSolutionSpecificationSheetService.selectProProductionSolutionSpecificationSheetList(proProductionSolutionSpecificationSheet);
        return getDataTable(list);
    }

    /**
     * 导出生产方案规格书列表
     */
    @PreAuthorize("@ss.hasPermi('pro:specificationSheet:export')")
    @Log(title = "生产方案规格书", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProProductionSolutionSpecificationSheet proProductionSolutionSpecificationSheet) {
        List<ProProductionSolutionSpecificationSheet> list = proProductionSolutionSpecificationSheetService.selectProProductionSolutionSpecificationSheetList(proProductionSolutionSpecificationSheet);
        ExcelUtil<ProProductionSolutionSpecificationSheet> util = new ExcelUtil<ProProductionSolutionSpecificationSheet>(ProProductionSolutionSpecificationSheet.class);
        util.exportExcel(response, list, "生产方案规格书数据");
    }

    /**
     * 获取生产方案规格书详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:specificationSheet:query')")
    @GetMapping(value = "/{specificationSheetId}")
    public AjaxResult getInfo(@PathVariable("specificationSheetId") Long specificationSheetId) {
        return AjaxResult.success(proProductionSolutionSpecificationSheetService.selectProProductionSolutionSpecificationSheetBySpecificationSheetId(specificationSheetId));
    }

    /**
     * 获取生产方案规格书详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:specificationSheet:query')")
    @GetMapping(value = "/info/{workorderId}")
    public AjaxResult getInfoV2(@PathVariable("workorderId") Long workorderId) {
        return AjaxResult.success(proProductionSolutionSpecificationSheetService.getInfoByWorkorderId(workorderId));
    }


    /**
     * 新增生产方案规格书
     */
    @PreAuthorize("@ss.hasPermi('pro:specificationSheet:add')")
    @Log(title = "生产方案规格书", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProProductionSolutionSpecificationSheet proProductionSolutionSpecificationSheet) {
        return toAjax(proProductionSolutionSpecificationSheetService.insertProProductionSolutionSpecificationSheet(proProductionSolutionSpecificationSheet));
    }

    /**
     * 修改生产方案规格书
     */
    @PreAuthorize("@ss.hasPermi('pro:specificationSheet:edit')")
    @Log(title = "生产方案规格书", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductionSolutionSpecificationSheet proProductionSolutionSpecificationSheet) {
        return toAjax(proProductionSolutionSpecificationSheetService.updateProProductionSolutionSpecificationSheet(proProductionSolutionSpecificationSheet));
    }

    /**
     * 删除生产方案规格书
     */
    @PreAuthorize("@ss.hasPermi('pro:specificationSheet:remove')")
    @Log(title = "生产方案规格书", businessType = BusinessType.DELETE)
    @DeleteMapping("/{specificationSheetIds}")
    public AjaxResult remove(@PathVariable Long[] specificationSheetIds) {
        return toAjax(proProductionSolutionSpecificationSheetService.deleteProProductionSolutionSpecificationSheetBySpecificationSheetIds(specificationSheetIds));
    }
}
