package com.ximai.mes.pro.controller.productionSolution;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import io.swagger.annotations.ApiOperation;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcessDrawing;
import com.ximai.mes.pro.dto.productionSolution.ProProductionSolutionProcessDrawingDto;
import com.ximai.mes.pro.dto.productionSolution.ProProductionSolutionProcessDrawingCreate;
import com.ximai.mes.pro.dto.productionSolution.ProProductionSolutionProcessDrawingUpdate;
import com.ximai.mes.pro.dto.productionSolution.ProProductionSolutionProcessDrawingExcelExport;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionProcessDrawingService;
import com.ximai.common.utils.poi.ExcelUtil;
import cn.hutool.core.bean.BeanUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 生产版本工序图纸Controller
 *
 * @author generator
 * @date 2024-08-29
 */
@RestController
@RequestMapping("/pro/drawing")
public class ProProductionSolutionProcessDrawingController extends BaseController
{
    @Autowired
    private IProProductionSolutionProcessDrawingService proProductionSolutionProcessDrawingService;

    /**
     * 查询生产版本工序图纸列表
     */
    @ApiOperation("查询生产版本工序图纸列表")
    @PreAuthorize("@ss.hasPermi('pro:drawing:list')")
    @GetMapping("/list")
    public TableDataInfo<ProProductionSolutionProcessDrawingDto> list(ProProductionSolutionProcessDrawing proProductionSolutionProcessDrawing)
    {
        startPage();
        List<ProProductionSolutionProcessDrawingDto> list = proProductionSolutionProcessDrawingService.selectProProductionSolutionProcessDrawingList(proProductionSolutionProcessDrawing);
        return getDataTable(list);
    }

    /**
     * 导出生产版本工序图纸列表
     */
    @ApiOperation("导出生产版本工序图纸列表")
    @PreAuthorize("@ss.hasPermi('pro:drawing:export')")
    @Log(title = "生产版本工序图纸", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProProductionSolutionProcessDrawing proProductionSolutionProcessDrawing)
    {
        List<ProProductionSolutionProcessDrawingDto> list = proProductionSolutionProcessDrawingService.selectProProductionSolutionProcessDrawingList(proProductionSolutionProcessDrawing);
        ExcelUtil<ProProductionSolutionProcessDrawingExcelExport> util = new ExcelUtil<ProProductionSolutionProcessDrawingExcelExport>(ProProductionSolutionProcessDrawingExcelExport.class);
        List<ProProductionSolutionProcessDrawingExcelExport> tempList = BeanUtil.copyToList(list, ProProductionSolutionProcessDrawingExcelExport.class);
        util.exportExcel(response, tempList, "生产版本工序图纸数据");
    }

    /**
     * 获取生产版本工序图纸详细信息
     */
    @ApiOperation("获取生产版本工序图纸详细信息")
    @PreAuthorize("@ss.hasPermi('pro:drawing:query')")
    @GetMapping(value = "/{productionSolutionProcessFileId}")
    public AjaxResult<ProProductionSolutionProcessDrawingDto> getInfo(@PathVariable("productionSolutionProcessFileId") Long productionSolutionProcessFileId)
    {
        return AjaxResult.success(proProductionSolutionProcessDrawingService.selectProProductionSolutionProcessDrawingDtoByProductionSolutionProcessFileId(productionSolutionProcessFileId));
    }

    /**
     * 新增生产版本工序图纸
     */
    @ApiOperation("新增生产版本工序图纸")
    @PreAuthorize("@ss.hasPermi('pro:drawing:add')")
    @Log(title = "生产版本工序图纸", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProProductionSolutionProcessDrawingCreate proProductionSolutionProcessDrawingCreate)
    {
        return toAjax(proProductionSolutionProcessDrawingService.insertProProductionSolutionProcessDrawing(proProductionSolutionProcessDrawingCreate));
    }

    /**
     * 修改生产版本工序图纸
     */
    @ApiOperation("修改生产版本工序图纸")
    @PreAuthorize("@ss.hasPermi('pro:drawing:edit')")
    @Log(title = "生产版本工序图纸", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductionSolutionProcessDrawingUpdate proProductionSolutionProcessDrawingUpdate)
    {
        return toAjax(proProductionSolutionProcessDrawingService.updateProProductionSolutionProcessDrawing(proProductionSolutionProcessDrawingUpdate));
    }

    /**
     * 删除生产版本工序图纸
     */
    @ApiOperation("删除生产版本工序图纸")
    @PreAuthorize("@ss.hasPermi('pro:drawing:remove')")
    @Log(title = "生产版本工序图纸", businessType = BusinessType.DELETE)
	@DeleteMapping("/{productionSolutionProcessFileIds}")
    public AjaxResult remove(@PathVariable Long[] productionSolutionProcessFileIds)
    {
        return toAjax(proProductionSolutionProcessDrawingService.deleteProProductionSolutionProcessDrawingByProductionSolutionProcessFileIds(productionSolutionProcessFileIds));
    }
}
