package com.ximai.mes.pro.controller.productionSolution;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.framework.security.BasicAuth;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolution;
import com.ximai.mes.pro.domain.vo.ProProductionSolutionVo;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 生产版本Controller
 *
 * @author zht
 * @date 2024-01-23
 */
@RestController
@RequestMapping("pro/productionSolution")
public class ProProductionSolutionController extends BaseController {
    @Autowired
    private IProProductionSolutionService proProductionSolutionService;

    /**
     * 查询生产版本列表
     */
    @ApiOperation(value = "查询生产版本列表")
    @PreAuthorize("@ss.hasPermi('mes:pro:productionSolution:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProProductionSolution proProductionSolution) {
        startPage();
        List<ProProductionSolution> list = proProductionSolutionService.selectProProductionSolutionList(proProductionSolution);
        return getDataTable(list);
    }

    /**
     * 导出生产版本列表
     */
    @PreAuthorize("@ss.hasPermi('mes:pro:productionSolution:export')")
    @Log(title = "生产版本", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProProductionSolution proProductionSolution) {
        List<ProProductionSolution> list = proProductionSolutionService.selectProProductionSolutionList(proProductionSolution);
        ExcelUtil<ProProductionSolution> util = new ExcelUtil<>(ProProductionSolution.class);
        util.exportExcel(response, list, "生产版本数据");
    }

    /**
     * 获取生产版本详细信息
     */
//    @PreAuthorize("@ss.hasPermi('mes:pro:productionSolution:query')")
    @GetMapping(value = "/{productionSolutionId}")
    public AjaxResult getInfo(@PathVariable("productionSolutionId") Long productionSolutionId) {
        return AjaxResult.success(proProductionSolutionService.selectProProductionSolutionByProductionSolutionId(productionSolutionId));
    }

    /**
     * 新增生产版本
     */
    @ApiOperation(value = "新增生产版本")
    @PreAuthorize("@ss.hasPermi('mes:pro:productionSolution:add')")
    @Log(title = "生产版本", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProProductionSolutionVo proProductionSolutionVo) {
        return toAjax(proProductionSolutionService.insertProProductionSolution(proProductionSolutionVo));
    }

    /**
     * 修改生产版本
     */
    @ApiOperation(value = "修改生产版本")
    @PreAuthorize("@ss.hasPermi('mes:pro:productionSolution:edit')")
    @Log(title = "生产版本", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductionSolutionVo proProductionSolution) {
        return toAjax(proProductionSolutionService.updateProProductionSolution(proProductionSolution));
    }

    /**
     * 删除生产版本
     */
    @ApiOperation(value = "删除生产版本")
    @PreAuthorize("@ss.hasPermi('mes:pro:productionSolution:remove')")
    @Log(title = "生产版本", businessType = BusinessType.DELETE)
    @DeleteMapping("/{productionSolutionIds}")
    public AjaxResult remove(@PathVariable Long[] productionSolutionIds) {
        return toAjax(proProductionSolutionService.deleteProProductionSolutionByProductionSolutionIds(productionSolutionIds));
    }

    /**
     * 接收EP的生产版本
     */
    @ApiOperation(value = "生产版本创建")
    @BasicAuth
    @RequestMapping(value = "/productionSolutionCreate", method = RequestMethod.POST)
    public AjaxResult productionSolutionCreate(@RequestBody ProProductionSolutionVo productionSolutionVo) {

        int i = proProductionSolutionService.productionSolutionCreate(productionSolutionVo);
        if (i == 9) {
            return AjaxResult.error("传入数据为空");
        }
        if (i == 2) {
            return AjaxResult.error("保存失败");
        }
        if (i == 3) {
            return AjaxResult.error("数据不存在");
        }
        if (i == 4) {
            return AjaxResult.error("删除失败");
        }

        return AjaxResult.success();
    }

    /**
     * 提交生产版本
     */
    @PreAuthorize("@ss.hasPermi('pro:productionSolution:edit')")
    @Log(title = "生产版本", businessType = BusinessType.UPDATE)
    @PutMapping("/submit")
    public AjaxResult submit(@RequestBody ProProductionSolutionVo proProductionSolutionVo) {
        return toAjax(proProductionSolutionService.submitProProductionSolution(proProductionSolutionVo));
    }
}
