package com.ximai.mes.pro.controller.productionRequest;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.productionRequest.ProProductionRequestProcessItem;
import com.ximai.mes.pro.service.productionRequest.IProProductionRequestProcessItemService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 量产申请工序物料Controller
 *
 * @author chicheng.li
 * @date 2024-01-22
 */
@RestController
@RequestMapping("/mes/pro/productionRequestProcessItem")
public class ProProductionRequestProcessItemController extends BaseController
{
    @Autowired
    private IProProductionRequestProcessItemService proProductionRequestProcessItemService;

    /**
     * 查询量产申请工序物料列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequestProcessItem:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProProductionRequestProcessItem proProductionRequestProcessItem)
    {
        startPage();
        List<ProProductionRequestProcessItem> list = proProductionRequestProcessItemService.selectProProductionRequestProcessItemList(proProductionRequestProcessItem);
        return getDataTable(list);
    }

    /**
     * 导出量产申请工序物料列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequestProcessItem:export')")
    @Log(title = "量产申请工序物料", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProProductionRequestProcessItem proProductionRequestProcessItem)
    {
        List<ProProductionRequestProcessItem> list = proProductionRequestProcessItemService.selectProProductionRequestProcessItemList(proProductionRequestProcessItem);
        ExcelUtil<ProProductionRequestProcessItem> util = new ExcelUtil<ProProductionRequestProcessItem>(ProProductionRequestProcessItem.class);
        util.exportExcel(response, list, "量产申请工序物料数据");
    }

    /**
     * 获取量产申请工序物料详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequestProcessItem:query')")
    @GetMapping(value = "/{productionRequestProcessItemId}")
    public AjaxResult getInfo(@PathVariable("productionRequestProcessItemId") Long productionRequestProcessItemId)
    {
        return AjaxResult.success(proProductionRequestProcessItemService.selectProProductionRequestProcessItemByProductionRequestProcessItemId(productionRequestProcessItemId));
    }

    /**
     * 新增量产申请工序物料
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequestProcessItem:add')")
    @Log(title = "量产申请工序物料", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProProductionRequestProcessItem proProductionRequestProcessItem)
    {
        return toAjax(proProductionRequestProcessItemService.insertProProductionRequestProcessItem(proProductionRequestProcessItem));
    }

    /**
     * 修改量产申请工序物料
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequestProcessItem:edit')")
    @Log(title = "量产申请工序物料", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductionRequestProcessItem proProductionRequestProcessItem)
    {
        return toAjax(proProductionRequestProcessItemService.updateProProductionRequestProcessItem(proProductionRequestProcessItem));
    }

    /**
     * 删除量产申请工序物料
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequestProcessItem:remove')")
    @Log(title = "量产申请工序物料", businessType = BusinessType.DELETE)
	@DeleteMapping("/{productionRequestProcessItemIds}")
    public AjaxResult remove(@PathVariable Long[] productionRequestProcessItemIds)
    {
        return toAjax(proProductionRequestProcessItemService.deleteProProductionRequestProcessItemByProductionRequestProcessItemIds(productionRequestProcessItemIds));
    }
}
