package com.ximai.mes.pro.controller.productionRequest;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.productionRequest.ProProductionRequestBom;
import com.ximai.mes.pro.service.productionRequest.IProProductionRequestBomService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 量产申请BOMController
 *
 * @author chicheng.li
 * @date 2024-01-22
 */
@RestController
@RequestMapping("/mes/pro/productionRequestBom")
public class ProProductionRequestBomController extends BaseController
{
    @Autowired
    private IProProductionRequestBomService proProductionRequestBomService;

    /**
     * 查询量产申请BOM列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequestBom:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProProductionRequestBom proProductionRequestBom)
    {
        startPage();
        List<ProProductionRequestBom> list = proProductionRequestBomService.selectProProductionRequestBomList(proProductionRequestBom);
        return getDataTable(list);
    }

    /**
     * 导出量产申请BOM列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequestBom:export')")
    @Log(title = "量产申请BOM", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProProductionRequestBom proProductionRequestBom)
    {
        List<ProProductionRequestBom> list = proProductionRequestBomService.selectProProductionRequestBomList(proProductionRequestBom);
        ExcelUtil<ProProductionRequestBom> util = new ExcelUtil<ProProductionRequestBom>(ProProductionRequestBom.class);
        util.exportExcel(response, list, "量产申请BOM数据");
    }

    /**
     * 获取量产申请BOM详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequestBom:query')")
    @GetMapping(value = "/{bomItemId}")
    public AjaxResult getInfo(@PathVariable("bomItemId") Long bomItemId)
    {
        return AjaxResult.success(proProductionRequestBomService.selectProProductionRequestBomByBomItemId(bomItemId));
    }

    /**
     * 新增量产申请BOM
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequestBom:add')")
    @Log(title = "量产申请BOM", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProProductionRequestBom proProductionRequestBom)
    {
        return toAjax(proProductionRequestBomService.insertProProductionRequestBom(proProductionRequestBom));
    }

    /**
     * 修改量产申请BOM
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequestBom:edit')")
    @Log(title = "量产申请BOM", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductionRequestBom proProductionRequestBom)
    {
        return toAjax(proProductionRequestBomService.updateProProductionRequestBom(proProductionRequestBom));
    }

    /**
     * 删除量产申请BOM
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequestBom:remove')")
    @Log(title = "量产申请BOM", businessType = BusinessType.DELETE)
	@DeleteMapping("/{bomItemIds}")
    public AjaxResult remove(@PathVariable Long[] bomItemIds)
    {
        return toAjax(proProductionRequestBomService.deleteProProductionRequestBomByBomItemIds(bomItemIds));
    }
}
