package com.ximai.mes.pro.controller.productionMake;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.productionMake.ProProductionMakeProcess;
import com.ximai.mes.pro.service.productionMake.IProProductionMakeProcessService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 量产制作工序Controller
 *
 * @author chicheng.li
 * @date 2024-01-23
 */
@RestController
@RequestMapping("/mes/pro/productionMakeProcess")
public class ProProductionMakeProcessController extends BaseController
{
    @Autowired
    private IProProductionMakeProcessService proProductionMakeProcessService;

    /**
     * 查询量产制作工序列表
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMakeProcess:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProProductionMakeProcess proProductionMakeProcess)
    {
        startPage();
        List<ProProductionMakeProcess> list = proProductionMakeProcessService.selectProProductionMakeProcessList(proProductionMakeProcess);
        return getDataTable(list);
    }

    /**
     * 导出量产制作工序列表
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMakeProcess:export')")
    @Log(title = "量产制作工序", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProProductionMakeProcess proProductionMakeProcess)
    {
        List<ProProductionMakeProcess> list = proProductionMakeProcessService.selectProProductionMakeProcessList(proProductionMakeProcess);
        ExcelUtil<ProProductionMakeProcess> util = new ExcelUtil<ProProductionMakeProcess>(ProProductionMakeProcess.class);
        util.exportExcel(response, list, "量产制作工序数据");
    }

    /**
     * 获取量产制作工序详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMakeProcess:query')")
    @GetMapping(value = "/{productionMakeProcessId}")
    public AjaxResult getInfo(@PathVariable("productionMakeProcessId") Long productionMakeProcessId)
    {
        return AjaxResult.success(proProductionMakeProcessService.selectProProductionMakeProcessByProductionMakeProcessId(productionMakeProcessId));
    }

    /**
     * 新增量产制作工序
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMakeProcess:add')")
    @Log(title = "量产制作工序", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProProductionMakeProcess proProductionMakeProcess)
    {
        return toAjax(proProductionMakeProcessService.insertProProductionMakeProcess(proProductionMakeProcess));
    }

    /**
     * 修改量产制作工序
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMakeProcess:edit')")
    @Log(title = "量产制作工序", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductionMakeProcess proProductionMakeProcess)
    {
        return toAjax(proProductionMakeProcessService.updateProProductionMakeProcess(proProductionMakeProcess));
    }

    /**
     * 删除量产制作工序
     */
    @PreAuthorize("@ss.hasPermi('pro:productionMakeProcess:remove')")
    @Log(title = "量产制作工序", businessType = BusinessType.DELETE)
	@DeleteMapping("/{productionMakeProcessIds}")
    public AjaxResult remove(@PathVariable Long[] productionMakeProcessIds)
    {
        return toAjax(proProductionMakeProcessService.deleteProProductionMakeProcessByProductionMakeProcessIds(productionMakeProcessIds));
    }
}
