package com.ximai.mes.pro.controller.proWorkOrder;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.pro.domain.vo.proWorkOrder.ProWorkOrderSoSizeItemDynamic;
import io.swagger.annotations.ApiOperation;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderSoSizeItem;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderSoSizeItemService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 生产工单尺码Controller
 *
 * @author zht
 * @date 2024-02-29
 */
@RestController
@RequestMapping("/mes/pro/workOrderSoSizeItem")
public class ProWorkOrderSoSizeItemController extends BaseController
{
    @Autowired
    private IProWorkOrderSoSizeItemService proWorkOrderSoSizeItemService;

    /**
     * 查询生产工单尺码列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderSoSizeItem:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProWorkOrderSoSizeItem proWorkOrderSoSizeItem)
    {
        startPage();
        List<ProWorkOrderSoSizeItem> list = proWorkOrderSoSizeItemService.selectProWorkOrderSoSizeItemList(proWorkOrderSoSizeItem);
        return getDataTable(list);
    }

    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderSoSizeItem:list')")
    @GetMapping("/listDynamic")
    @ApiOperation("动态列查询生产工单尺码列表")
    public AjaxResult<ProWorkOrderSoSizeItemDynamic> listDynamic(ProWorkOrderSoSizeItem proWorkOrderSoSizeItem)
    {
        ProWorkOrderSoSizeItemDynamic rst = proWorkOrderSoSizeItemService.selectProWorkOrderSoSizeItemListDynamic(proWorkOrderSoSizeItem);
        return AjaxResult.success(rst);
    }

    /**
     * 导出生产工单尺码列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderSoSizeItem:export')")
    @Log(title = "生产工单尺码", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProWorkOrderSoSizeItem proWorkOrderSoSizeItem)
    {
        List<ProWorkOrderSoSizeItem> list = proWorkOrderSoSizeItemService.selectProWorkOrderSoSizeItemList(proWorkOrderSoSizeItem);
        ExcelUtil<ProWorkOrderSoSizeItem> util = new ExcelUtil<ProWorkOrderSoSizeItem>(ProWorkOrderSoSizeItem.class);
        util.exportExcel(response, list, "生产工单尺码数据");
    }

    /**
     * 获取生产工单尺码详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderSoSizeItem:query')")
    @GetMapping(value = "/{workorderSoSizeItemId}")
    public AjaxResult getInfo(@PathVariable("workorderSoSizeItemId") Long workorderSoSizeItemId)
    {
        return AjaxResult.success(proWorkOrderSoSizeItemService.selectProWorkOrderSoSizeItemByWorkorderSoSizeItemId(workorderSoSizeItemId));
    }

    /**
     * 新增生产工单尺码
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderSoSizeItem:add')")
    @Log(title = "生产工单尺码", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProWorkOrderSoSizeItem proWorkOrderSoSizeItem)
    {
        return toAjax(proWorkOrderSoSizeItemService.insertProWorkOrderSoSizeItem(proWorkOrderSoSizeItem));
    }

    /**
     * 修改生产工单尺码
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderSoSizeItem:edit')")
    @Log(title = "生产工单尺码", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProWorkOrderSoSizeItem proWorkOrderSoSizeItem)
    {
        return toAjax(proWorkOrderSoSizeItemService.updateProWorkOrderSoSizeItem(proWorkOrderSoSizeItem));
    }

    /**
     * 删除生产工单尺码
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderSoSizeItem:remove')")
    @Log(title = "生产工单尺码", businessType = BusinessType.DELETE)
	@DeleteMapping("/{workorderSoSizeItemIds}")
    public AjaxResult remove(@PathVariable Long[] workorderSoSizeItemIds)
    {
        return toAjax(proWorkOrderSoSizeItemService.deleteProWorkOrderSoSizeItemByWorkorderSoSizeItemIds(workorderSoSizeItemIds));
    }
}
