package com.ximai.mes.pro.controller.proWorkOrder;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderSoDirective;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderSoDirectiveService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 生产工单指令Controller
 *
 * @author zht
 * @date 2024-02-29
 */
@RestController
@RequestMapping("/mes/pro/workOrderSoDirective")
public class ProWorkOrderSoDirectiveController extends BaseController {
    @Autowired
    private IProWorkOrderSoDirectiveService proWorkOrderSoDirectiveService;

    /**
     * 查询生产工单指令列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderSoDirective:list')")
    @GetMapping("/list")
    @ApiOperation("查询生产工单指令列表")
    public TableDataInfo<ProWorkOrderSoDirective> list(ProWorkOrderSoDirective proWorkOrderSoDirective) {
        startPage();
        List<ProWorkOrderSoDirective> list = proWorkOrderSoDirectiveService.selectProWorkOrderSoDirectiveList(proWorkOrderSoDirective);
        return getDataTable(list);
    }

    /**
     * 导出生产工单指令列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderSoDirective:export')")
    @Log(title = "生产工单指令", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProWorkOrderSoDirective proWorkOrderSoDirective) {
        List<ProWorkOrderSoDirective> list = proWorkOrderSoDirectiveService.selectProWorkOrderSoDirectiveList(proWorkOrderSoDirective);
        ExcelUtil<ProWorkOrderSoDirective> util = new ExcelUtil<ProWorkOrderSoDirective>(ProWorkOrderSoDirective.class);
        util.exportExcel(response, list, "生产工单指令数据");
    }

    /**
     * 获取生产工单指令详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderSoDirective:query')")
    @GetMapping(value = "/{workorderSoDirectiveId}")
    public AjaxResult getInfo(@PathVariable("workorderSoDirectiveId") Long workorderSoDirectiveId) {
        return AjaxResult.success(proWorkOrderSoDirectiveService.selectProWorkOrderSoDirectiveByWorkorderSoDirectiveId(workorderSoDirectiveId));
    }

    /**
     * 新增生产工单指令
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderSoDirective:add')")
    @Log(title = "生产工单指令", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProWorkOrderSoDirective proWorkOrderSoDirective) {
        return toAjax(proWorkOrderSoDirectiveService.insertProWorkOrderSoDirective(proWorkOrderSoDirective));
    }

    /**
     * 修改生产工单指令
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderSoDirective:edit')")
    @Log(title = "生产工单指令", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProWorkOrderSoDirective proWorkOrderSoDirective) {
        return toAjax(proWorkOrderSoDirectiveService.updateProWorkOrderSoDirective(proWorkOrderSoDirective));
    }

    /**
     * 删除生产工单指令
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderSoDirective:remove')")
    @Log(title = "生产工单指令", businessType = BusinessType.DELETE)
    @DeleteMapping("/{workorderSoDirectiveIds}")
    public AjaxResult remove(@PathVariable Long[] workorderSoDirectiveIds) {
        return toAjax(proWorkOrderSoDirectiveService.deleteProWorkOrderSoDirectiveByWorkorderSoDirectiveIds(workorderSoDirectiveIds));
    }
}
