package com.ximai.mes.pro.controller.proWorkOrder;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcessTool;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderProcessToolService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 工单工序质检项Controller
 *
 * @author zht
 * @date 2024-01-28
 */
@RestController
@RequestMapping("/mes/pro/workOrderProcessTool")
public class ProWorkOrderProcessToolController extends BaseController {
    @Autowired
    private IProWorkOrderProcessToolService proWorkOrderProcessToolService;

    /**
     * 查询工单工序质检项列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderProcessTool:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProWorkOrderProcessTool proWorkOrderProcessTool) {
        startPage();
        List<ProWorkOrderProcessTool> list = proWorkOrderProcessToolService.selectProWorkOrderProcessToolList(proWorkOrderProcessTool);
        return getDataTable(list);
    }

    /**
     * 导出工单工序质检项列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderProcessTool:export')")
    @Log(title = "工单工序质检项", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProWorkOrderProcessTool proWorkOrderProcessTool) {
        List<ProWorkOrderProcessTool> list = proWorkOrderProcessToolService.selectProWorkOrderProcessToolList(proWorkOrderProcessTool);
        ExcelUtil<ProWorkOrderProcessTool> util = new ExcelUtil<ProWorkOrderProcessTool>(ProWorkOrderProcessTool.class);
        util.exportExcel(response, list, "工单工序质检项数据");
    }

    /**
     * 获取工单工序质检项详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderProcessTool:query')")
    @GetMapping(value = "/{workorderProcessToolId}")
    public AjaxResult getInfo(@PathVariable("workorderProcessToolId") Long workorderProcessToolId) {
        return AjaxResult.success(proWorkOrderProcessToolService.selectProWorkOrderProcessToolByWorkorderProcessToolId(workorderProcessToolId));
    }

    /**
     * 新增工单工序质检项
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderProcessTool:add')")
    @Log(title = "工单工序质检项", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProWorkOrderProcessTool proWorkOrderProcessTool) {
        return toAjax(proWorkOrderProcessToolService.insertProWorkOrderProcessTool(proWorkOrderProcessTool));
    }

    /**
     * 修改工单工序质检项
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderProcessTool:edit')")
    @Log(title = "工单工序质检项", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProWorkOrderProcessTool proWorkOrderProcessTool) {
        return toAjax(proWorkOrderProcessToolService.updateProWorkOrderProcessTool(proWorkOrderProcessTool));
    }

    /**
     * 删除工单工序质检项
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderProcessTool:remove')")
    @Log(title = "工单工序质检项", businessType = BusinessType.DELETE)
    @DeleteMapping("/{workorderProcessToolIds}")
    public AjaxResult remove(@PathVariable Long[] workorderProcessToolIds) {
        return toAjax(proWorkOrderProcessToolService.deleteProWorkOrderProcessToolByWorkorderProcessToolIds(workorderProcessToolIds));
    }
}
