package com.ximai.mes.pro.controller.proWorkOrder;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcessQcindex;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderProcessQcindexService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 工单工序工装Controller
 *
 * @author zht
 * @date 2024-01-28
 */
@RestController
@RequestMapping("/mes/pro/workOrderProcessQcindex")
public class ProWorkOrderProcessQcindexController extends BaseController
{
    @Autowired
    private IProWorkOrderProcessQcindexService proWorkOrderProcessQcindexService;

    /**
     * 查询工单工序工装列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderProcessQcindex:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProWorkOrderProcessQcindex proWorkOrderProcessQcindex)
    {
        startPage();
        List<ProWorkOrderProcessQcindex> list = proWorkOrderProcessQcindexService.selectProWorkOrderProcessQcindexList(proWorkOrderProcessQcindex);
        return getDataTable(list);
    }

    /**
     * 导出工单工序工装列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderProcessQcindex:export')")
    @Log(title = "工单工序工装", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProWorkOrderProcessQcindex proWorkOrderProcessQcindex)
    {
        List<ProWorkOrderProcessQcindex> list = proWorkOrderProcessQcindexService.selectProWorkOrderProcessQcindexList(proWorkOrderProcessQcindex);
        ExcelUtil<ProWorkOrderProcessQcindex> util = new ExcelUtil<ProWorkOrderProcessQcindex>(ProWorkOrderProcessQcindex.class);
        util.exportExcel(response, list, "工单工序工装数据");
    }

    /**
     * 获取工单工序工装详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderProcessQcindex:query')")
    @GetMapping(value = "/{workorderProcessQcindex}")
    public AjaxResult getInfo(@PathVariable("workorderProcessQcindex") Long workorderProcessQcindex)
    {
        return AjaxResult.success(proWorkOrderProcessQcindexService.selectProWorkOrderProcessQcindexByWorkorderProcessQcindex(workorderProcessQcindex));
    }

    /**
     * 新增工单工序工装
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderProcessQcindex:add')")
    @Log(title = "工单工序工装", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProWorkOrderProcessQcindex proWorkOrderProcessQcindex)
    {
        return toAjax(proWorkOrderProcessQcindexService.insertProWorkOrderProcessQcindex(proWorkOrderProcessQcindex));
    }

    /**
     * 修改工单工序工装
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderProcessQcindex:edit')")
    @Log(title = "工单工序工装", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProWorkOrderProcessQcindex proWorkOrderProcessQcindex)
    {
        return toAjax(proWorkOrderProcessQcindexService.updateProWorkOrderProcessQcindex(proWorkOrderProcessQcindex));
    }

    /**
     * 删除工单工序工装
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:workOrderProcessQcindex:remove')")
    @Log(title = "工单工序工装", businessType = BusinessType.DELETE)
	@DeleteMapping("/{workorderProcessQcindexs}")
    public AjaxResult remove(@PathVariable Long[] workorderProcessQcindexs)
    {
        return toAjax(proWorkOrderProcessQcindexService.deleteProWorkOrderProcessQcindexByWorkorderProcessQcindexs(workorderProcessQcindexs));
    }
}
