package com.ximai.mes.pro.controller.proWorkOrder;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderDtaRecord;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderDtaRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * dto排版记录Controller
 *
 * @author generator
 * @date 2024-05-18
 */
@RestController
@RequestMapping("/md/dta/record")
public class ProWorkOrderDtaRecordController extends BaseController {
    @Autowired
    private IProWorkOrderDtaRecordService proWorkOrderDtaRecordService;

    /**
     * 查询dto排版记录列表
     */
    @PreAuthorize("@ss.hasPermi('md:record:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProWorkOrderDtaRecord proWorkOrderDtaRecord) {
        startPage();
        List<ProWorkOrderDtaRecord> list = proWorkOrderDtaRecordService.selectProWorkOrderDtoRecordList(proWorkOrderDtaRecord);
        return getDataTable(list);
    }

    /**
     * 导出dto排版记录列表
     */
    @PreAuthorize("@ss.hasPermi('md:record:export')")
    @Log(title = "dto排版记录", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProWorkOrderDtaRecord proWorkOrderDtaRecord) {
        List<ProWorkOrderDtaRecord> list = proWorkOrderDtaRecordService.selectProWorkOrderDtoRecordList(proWorkOrderDtaRecord);
        ExcelUtil<ProWorkOrderDtaRecord> util = new ExcelUtil<ProWorkOrderDtaRecord>(ProWorkOrderDtaRecord.class);
        util.exportExcel(response, list, "dto排版记录数据");
    }

    /**
     * 获取dto排版记录详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:record:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(proWorkOrderDtaRecordService.selectProWorkOrderDtoRecordById(id));
    }

    /**
     * 新增dto排版记录
     */
    @PreAuthorize("@ss.hasPermi('md:record:add')")
    @Log(title = "dto排版记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProWorkOrderDtaRecord proWorkOrderDtaRecord) {
        return toAjax(proWorkOrderDtaRecordService.insertProWorkOrderDtoRecord(proWorkOrderDtaRecord));
    }

    /**
     * 修改dto排版记录
     */
    @PreAuthorize("@ss.hasPermi('md:record:edit')")
    @Log(title = "dto排版记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProWorkOrderDtaRecord proWorkOrderDtaRecord) {
        return toAjax(proWorkOrderDtaRecordService.updateProWorkOrderDtoRecord(proWorkOrderDtaRecord));
    }

    /**
     * 修改dto排版记录
     */
    @PreAuthorize("@ss.hasPermi('md:record:edit')")
    @Log(title = "dto排版记录", businessType = BusinessType.UPDATE)
    @PutMapping("/confirm/{id}")
    public AjaxResult confirm(@PathVariable("id") Long id) {
        return toAjax(proWorkOrderDtaRecordService.confirm(id));
    }

    /**
     * 删除dto排版记录
     */
    @PreAuthorize("@ss.hasPermi('md:record:remove')")
    @Log(title = "dto排版记录", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(proWorkOrderDtaRecordService.deleteProWorkOrderDtoRecordByIds(ids));
    }
}
