package com.ximai.mes.pro.controller.proWorkOrder;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderBom;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderBomService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 生产工单BOMController
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
@RestController
@RequestMapping("/pro/workOrderBom")
public class ProWorkOrderBomController extends BaseController {
    @Autowired
    private IProWorkOrderBomService proWorkOrderBomService;

    /**
     * 查询生产工单BOM列表
     */
    @PreAuthorize("@ss.hasPermi('pro:workOrderBom:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProWorkOrderBom proWorkOrderBom) {
        startPage();
        List<ProWorkOrderBom> list = proWorkOrderBomService.selectProWorkOrderBomList(proWorkOrderBom);
        return getDataTable(list);
    }

    /**
     * 导出生产工单BOM列表
     */
    @PreAuthorize("@ss.hasPermi('pro:workOrderBom:export')")
    @Log(title = "生产工单BOM", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProWorkOrderBom proWorkOrderBom) {
        List<ProWorkOrderBom> list = proWorkOrderBomService.selectProWorkOrderBomList(proWorkOrderBom);
        ExcelUtil<ProWorkOrderBom> util = new ExcelUtil<ProWorkOrderBom>(ProWorkOrderBom.class);
        util.exportExcel(response, list, "生产工单BOM数据");
    }

    /**
     * 获取生产工单BOM详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:workOrderBom:query')")
    @GetMapping(value = "/{bomItemId}")
    public AjaxResult getInfo(@PathVariable("bomItemId") Long bomItemId) {
        return AjaxResult.success(proWorkOrderBomService.selectProWorkOrderBomByBomItemId(bomItemId));
    }

    /**
     * 新增生产工单BOM
     */
    @PreAuthorize("@ss.hasPermi('pro:workOrderBom:add')")
    @Log(title = "生产工单BOM", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProWorkOrderBom proWorkOrderBom) {
        return toAjax(proWorkOrderBomService.insertProWorkOrderBom(proWorkOrderBom));
    }
 
    /**
     * 修改生产工单BOM
     */
    @PreAuthorize("@ss.hasPermi('pro:workOrderBom:edit')")
    @Log(title = "生产工单BOM", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProWorkOrderBom proWorkOrderBom) {
        return toAjax(proWorkOrderBomService.updateProWorkOrderBom(proWorkOrderBom));
    }

    /**
     * 删除生产工单BOM
     */
    @PreAuthorize("@ss.hasPermi('pro:workOrderBom:remove')")
    @Log(title = "生产工单BOM", businessType = BusinessType.DELETE)
    @DeleteMapping("/{bomItemIds}")
    public AjaxResult remove(@PathVariable Long[] bomItemIds) {
        return toAjax(proWorkOrderBomService.deleteProWorkOrderBomByBomItemIds(bomItemIds));
    }
}
