package com.ximai.mes.pro.controller.mobile;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.ProProductionLog;
import com.ximai.mes.pro.service.IProProductionLogService;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 机器生产记录Controller
 *
 * @author yinjinlu
 * @date 2024-01-20
 */
@RestController
@RequestMapping("/mobile/pro/productionlog")
public class ProProductionLogController extends BaseController
{
    @Autowired
    private IProProductionLogService proProductionLogService;

    /**
     * 查询机器生产记录列表
     */
    @PreAuthorize("@ss.hasPermi('pro:ProProductionLog:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProProductionLog proProductionLog)
    {
        startPage();
        List<ProProductionLog> list = proProductionLogService.selectProProductionLogList(proProductionLog);
        return getDataTable(list);
    }

    /**
     * 导出机器生产记录列表
     */
    @PreAuthorize("@ss.hasPermi('pro:ProProductionLog:export')")
    @Log(title = "机器生产记录", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProProductionLog proProductionLog)
    {
        List<ProProductionLog> list = proProductionLogService.selectProProductionLogList(proProductionLog);
        ExcelUtil<ProProductionLog> util = new ExcelUtil<ProProductionLog>(ProProductionLog.class);
        util.exportExcel(response, list, "机器生产记录数据");
    }

    /**
     * 获取机器生产记录详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:ProProductionLog:query')")
    @GetMapping(value = "/{recordId}")
    public AjaxResult getInfo(@PathVariable("recordId") Long recordId)
    {
        return AjaxResult.success(proProductionLogService.selectProProductionLogByRecordId(recordId));
    }

    /**
     * 新增机器生产记录
     */
    @PreAuthorize("@ss.hasPermi('pro:ProProductionLog:add')")
    @Log(title = "机器生产记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(ProProductionLog proProductionLog)
    {
        return toAjax(proProductionLogService.insertProProductionLog(proProductionLog));
    }

    /**
     * 修改机器生产记录
     */
    @PreAuthorize("@ss.hasPermi('pro:ProProductionLog:edit')")
    @Log(title = "机器生产记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductionLog proProductionLog)
    {
        return toAjax(proProductionLogService.updateProProductionLog(proProductionLog));
    }

    /**
     * 删除机器生产记录
     */
    @PreAuthorize("@ss.hasPermi('pro:ProProductionLog:remove')")
    @Log(title = "机器生产记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{recordIds}")
    public AjaxResult remove(@PathVariable Long[] recordIds)
    {
        return toAjax(proProductionLogService.deleteProProductionLogByRecordIds(recordIds));
    }
}
