package com.ximai.mes.pro.controller.mobile;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.exception.ServiceException;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.mes.pro.domain.ProMaterialRequest;
import com.ximai.mes.pro.domain.ProMaterialReturn;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.pro.domain.vo.ProTaskVo;
import com.ximai.mes.pro.domain.vo.ProWorkOrderBomVo;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkorderMapper;
import com.ximai.mes.pro.mapper.task.ProTaskMapper;
import com.ximai.mes.pro.service.IProMaterialRequestService;
import com.ximai.mes.pro.service.IProMaterialReturnService;
import com.ximai.mes.pro.service.IProRecoilMaterialService;
import com.ximai.mes.pro.service.task.IProTaskService;
import com.ximai.mes.wm.domain.WmIssueLine;
import com.ximai.mes.wm.domain.tx.WmIssueLineJoinBean;
import com.ximai.mes.wm.mapper.WmIssueLineMapper;
import com.ximai.mes.wm.service.IWmIssueHeaderService;
import com.ximai.mes.wm.service.IWmIssueLineService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;


@Api("生产领料确认、退料、补料")
@RestController
@RequestMapping("/mobile/pro/proMaterial")
public class ProMaterialMobController extends BaseController {

    @Autowired
    private IProTaskService proTaskService;
    @Autowired
    private WmIssueLineMapper wmIssueLineMapper;
    @Autowired
    private IWmIssueLineService wmIssueLineService;
    @Autowired
    private IWmIssueHeaderService wmIssueHeaderService;
    @Autowired
    private ProTaskMapper proTaskMapper;
    @Autowired
    private IProMaterialRequestService proMaterialRequestService;
    @Autowired
    private IProMaterialReturnService proMaterialReturnService;
    @Autowired
    private IProRecoilMaterialService proRecoilMaterialService;
    @Autowired
    private ProWorkorderMapper proWorkorderMapper;


    @ApiOperation(value = "投料校验列表")
    @PostMapping("/listFeedingInspection")
    public AjaxResult listFeedingInspection2(@RequestParam("taskId") Long taskId) {
        List<WmIssueLineJoinBean> wmIssueLineJoinBeans = wmIssueLineService.listFeedingInspection(taskId);
        return AjaxResult.success(wmIssueLineJoinBeans);
    }

    @ApiOperation(value = "SAP领料清单明细查询")
    @PostMapping("/listIssueLine")
    public AjaxResult listFeedingInspection(@RequestParam("taskId") Long taskId, @RequestParam(name = "workorderCode", required = false) String workorderCode) {
        WmIssueLine wmIssueLine = new WmIssueLine();
        wmIssueLine.setTaskId(taskId);
        wmIssueLine.setWorkorderCode(workorderCode);
        List<WmIssueLineJoinBean> wmIssueLineJoinBeans = wmIssueLineService.selectWmIssueLineBeanList(wmIssueLine);
        return AjaxResult.success(wmIssueLineJoinBeans);
    }


    @ApiOperation(value = "退料界面")
    @PostMapping("/listIssueLineselect")
    public AjaxResult listFeedingInspectionSelect(@RequestParam("taskId") Long taskId, @RequestParam(name = "workorderCode", required = false) String workorderCode) {
        WmIssueLine wmIssueLine = new WmIssueLine();
        wmIssueLine.setTaskId(taskId);
        wmIssueLine.setWorkorderCode(workorderCode);
        List<WmIssueLineJoinBean> wmIssueLineJoinBeans = wmIssueLineService.selectWmIssueLineSelect(wmIssueLine);
        return AjaxResult.success(wmIssueLineJoinBeans);
    }



    @ApiOperation(value = "反冲料新增")
    @Log(title = "反冲料新增", businessType = BusinessType.INSERT)
    @PostMapping("/addRecoilMaterial")
    public AjaxResult addRecoilMaterial(@RequestParam("taskId") Long taskId, @RequestParam("plnr") String plnr) {
        proRecoilMaterialService.scan(plnr, taskId);
        return AjaxResult.success();
    }

    @ApiOperation(value = "删除反冲料关联")
    @PostMapping("/deleteRecoilMaterial")
    public AjaxResult deleteRecoilMaterial(@RequestParam("id") Long id) {
        proRecoilMaterialService.deleteProRecoilMaterialById(id);
        return AjaxResult.success();
    }


    @ApiOperation(value = "修改领料单状态为校验")
    @PostMapping("/validateFeedingInspection")
    public AjaxResult validateFeedingInspection(@RequestParam("plnr") String plnr, @RequestParam("taskId") Long taskId) {
        WmIssueLine wmIssueLine = new WmIssueLine();
        wmIssueLine.setPlNum(plnr);
        wmIssueLine.setTaskId(taskId);
        List<WmIssueLineJoinBean> wmIssueLineJoinBeans = wmIssueLineService.selectWmIssueLineBeanList(wmIssueLine);

        if (CollectionUtil.isEmpty(wmIssueLineJoinBeans)) {
            QueryWrapper<ProTask> query = new QueryWrapper<>();
            query.eq("t1.task_id", taskId);
            List<ProTaskVo> taskOrderlist = proTaskMapper.selectProTaskJoinWorkorder(query);
            Set<String> workorderCodeSet = taskOrderlist.stream().map(ProTaskVo::getWorkorderCode).collect(Collectors.toSet());
            ExceptionUtil.checkTrueThrowException(CollectionUtil.isEmpty(wmIssueLineJoinBeans), String.format("工单编码 ：%s ,该工单未找到生产领用记录", workorderCodeSet));
        }

        long count = wmIssueLineJoinBeans.stream().filter(x -> x.getAttr3() == 1).count();
        ExceptionUtil.checkTrueThrowException(wmIssueLineJoinBeans.size() == count, "重复校验");

        for (WmIssueLineJoinBean wmIssueLineJoinBean : wmIssueLineJoinBeans) {
            WmIssueLine issueLine = wmIssueLineJoinBean.deepSetObj(WmIssueLine.class);
            issueLine.setAttr3(1);
            wmIssueLineService.updateWmIssueLine(issueLine);
        }
        return AjaxResult.success();
    }

    @ApiOperation(value = "修改领料单状态为校验")
    @PostMapping("/validateFeedingInspectionById")
    public AjaxResult validateFeedingInspectionById(@RequestParam("lineId") Long lineId) {
        WmIssueLine issueLine = wmIssueLineMapper.selectWmIssueLineByLineId(lineId);
        if (issueLine.getAttr3() == 1) {
            throw new ServiceException("重复校验");
        }
        issueLine.setAttr3(1);
        wmIssueLineService.updateWmIssueLine(issueLine);
        return AjaxResult.success();
    }


    @ApiOperation(value = "查询编排单关联所有物料清单")
    @Log(title = "查询BOM物料清单", businessType = BusinessType.INSERT)
    @PostMapping("/listMaterialRequest")
    public AjaxResult listMaterialRequest(@RequestParam("taskId") Long taskId) {
        List<ProWorkOrderBomVo> list =proMaterialRequestService.selectMaterialLists(taskId);
        return AjaxResult.success(list);
    }


    @ApiOperation(value = "创建领料申请单")
    @PostMapping("/addMaterialRequest")
    public AjaxResult addMaterialRequest(@RequestBody List<ProMaterialRequest> appendList) {
        proMaterialRequestService.insertProMaterialRequest(appendList);
        return AjaxResult.success();
    }


    @ApiOperation(value = "创建退料申请单")
    @PostMapping("/addMaterialReturn")
    public AjaxResult addMaterialReturn(@RequestBody List<ProMaterialReturn> appendList) {
        proMaterialReturnService.insertProMaterialReturns(appendList);
        return AjaxResult.success("操作成功");
    }

}
