package com.ximai.mes.pro.controller;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.pro.domain.ProScheduleSetupRule;
import com.ximai.mes.pro.domain.vo.ProScheduleSetupRuleExcelExport;
import com.ximai.mes.pro.service.IProScheduleSetupRuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * 排产换型对照信息Controller
 *
 * @author generator
 * @date 2024-04-01
 */
@RestController
@RequestMapping("/pro/scheduleSetupRule")
public class ProScheduleSetupRuleController extends BaseController {

    @Autowired
    private IProScheduleSetupRuleService proScheduleSetupRuleService;

    /**
     * 查询排产换型对照信息列表
     */
    @PreAuthorize("@ss.hasPermi('pro:scheduleSetupRule:list')")
    @GetMapping("/list")
    public TableDataInfo<ProScheduleSetupRule> list(ProScheduleSetupRule proScheduleSetupRule) {
        startPage();
        List<ProScheduleSetupRule> list = proScheduleSetupRuleService.selectProScheduleSetupRuleList(proScheduleSetupRule);
        return getDataTable(list);
    }

    /**
     * 导出排产换型对照信息列表
     */
    @PreAuthorize("@ss.hasPermi('pro:scheduleSetupRule:export')")
    @Log(title = "排产换型对照信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProScheduleSetupRule proScheduleSetupRule) {
        List<ProScheduleSetupRule> list = proScheduleSetupRuleService.selectProScheduleSetupRuleList(proScheduleSetupRule);
        List<ProScheduleSetupRuleExcelExport> rstList = new ArrayList<ProScheduleSetupRuleExcelExport>();
        list.forEach(s -> {
            ProScheduleSetupRuleExcelExport temp = new ProScheduleSetupRuleExcelExport();
            BeanUtil.copyProperties(s, temp);
            rstList.add(temp);
        });
        ExcelUtil<ProScheduleSetupRuleExcelExport> util = new ExcelUtil<ProScheduleSetupRuleExcelExport>(ProScheduleSetupRuleExcelExport.class);
        util.exportExcel(response, rstList, "排产换型对照信息数据");
    }

    /**
     * 获取排产换型对照信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:scheduleSetupRule:query')")
    @GetMapping(value = "/{ruleId}")
    public AjaxResult getInfo(@PathVariable("ruleId") Long ruleId) {
        return AjaxResult.success(proScheduleSetupRuleService.selectProScheduleSetupRuleByRuleId(ruleId));
    }

    /**
     * 新增排产换型对照信息
     */
    @PreAuthorize("@ss.hasPermi('pro:scheduleSetupRule:add')")
    @Log(title = "排产换型对照信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProScheduleSetupRule proScheduleSetupRule) {
        return toAjax(proScheduleSetupRuleService.insertProScheduleSetupRule(proScheduleSetupRule));
    }

    /**
     * 修改排产换型对照信息
     */
    @PreAuthorize("@ss.hasPermi('pro:scheduleSetupRule:edit')")
    @Log(title = "排产换型对照信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProScheduleSetupRule proScheduleSetupRule) {
        return toAjax(proScheduleSetupRuleService.updateProScheduleSetupRule(proScheduleSetupRule));
    }

    /**
     * 删除排产换型对照信息
     */
    @PreAuthorize("@ss.hasPermi('pro:scheduleSetupRule:remove')")
    @Log(title = "排产换型对照信息", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ruleIds}")
    public AjaxResult remove(@PathVariable Long[] ruleIds) {
        return toAjax(proScheduleSetupRuleService.deleteProScheduleSetupRuleByRuleIds(ruleIds));
    }
}
