package com.ximai.mes.pro.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import io.swagger.annotations.ApiOperation;
import com.ximai.mes.pro.domain.ProProductQrcodeRule;
import com.ximai.mes.pro.dto.ProProductQrcodeRuleDto;
import com.ximai.mes.pro.dto.ProProductQrcodeRuleQuery;
import com.ximai.mes.pro.dto.ProProductQrcodeRuleCreate;
import com.ximai.mes.pro.dto.ProProductQrcodeRuleUpdate;
import com.ximai.mes.pro.dto.ProProductQrcodeRuleExcelExport;
import com.ximai.mes.pro.service.IProProductQrcodeRuleService;
import com.ximai.common.utils.poi.ExcelUtil;
import cn.hutool.core.bean.BeanUtil;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 产品二维码规则Controller
 *
 * @author generator
 * @date 2024-08-31
 */
@RestController
@RequestMapping("/pro/proQrcodeRule")
public class ProProductQrcodeRuleController extends BaseController
{
    @Autowired
    private IProProductQrcodeRuleService proProductQrcodeRuleService;

    /**
     * 查询产品二维码规则列表
     */
    @ApiOperation("查询产品二维码规则列表")
    @PreAuthorize("@ss.hasPermi('pro:proQrcodeRule:list')")
    @GetMapping("/list")
    public TableDataInfo<ProProductQrcodeRuleDto> list(ProProductQrcodeRuleQuery proProductQrcodeRuleQuery) {
        startPage();
        QueryWrapper<ProProductQrcodeRule> query = new QueryWrapper<>();
        query.eq(proProductQrcodeRuleQuery.getItemId()!=null, "m.item_id", proProductQrcodeRuleQuery.getItemId());
        query.eq(StringUtils.isNotEmpty(proProductQrcodeRuleQuery.getItemCode()), "m.item_code", proProductQrcodeRuleQuery.getItemCode());
        query.eq(StringUtils.isNotEmpty(proProductQrcodeRuleQuery.getPrefix()), "m.prefix", proProductQrcodeRuleQuery.getPrefix());
        query.eq(StringUtils.isNotEmpty(proProductQrcodeRuleQuery.getDatePattern()), "m.date_pattern", proProductQrcodeRuleQuery.getDatePattern());
        query.eq(proProductQrcodeRuleQuery.getSerialLen()!=null, "m.serial_len", proProductQrcodeRuleQuery.getSerialLen());
        query.eq(StringUtils.isNotEmpty(proProductQrcodeRuleQuery.getItemDesc()), "m.item_desc", proProductQrcodeRuleQuery.getItemDesc());
        query.eq(StringUtils.isNotEmpty(proProductQrcodeRuleQuery.getClientCode()), "m.client_code", proProductQrcodeRuleQuery.getClientCode());
        query.like(StringUtils.isNotEmpty(proProductQrcodeRuleQuery.getClientName()), "m.client_name", "%" + proProductQrcodeRuleQuery.getClientName() + "%");
        query.eq(proProductQrcodeRuleQuery.getCurrentSerial()!=null, "m.current_serial", proProductQrcodeRuleQuery.getCurrentSerial());
        List<ProProductQrcodeRuleDto> list = proProductQrcodeRuleService.selectProProductQrcodeRuleDtoList(query);
        return getDataTable(list);
    }

    /**
     * 导出产品二维码规则列表
     */
    @ApiOperation("导出产品二维码规则列表")
    @PreAuthorize("@ss.hasPermi('pro:proQrcodeRule:export')")
    @Log(title = "产品二维码规则", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProProductQrcodeRule proProductQrcodeRule) {
        List<ProProductQrcodeRuleDto> list = proProductQrcodeRuleService.selectProProductQrcodeRuleList(proProductQrcodeRule);
        ExcelUtil<ProProductQrcodeRuleExcelExport> util = new ExcelUtil<ProProductQrcodeRuleExcelExport>(ProProductQrcodeRuleExcelExport.class);
        List<ProProductQrcodeRuleExcelExport> tempList = BeanUtil.copyToList(list, ProProductQrcodeRuleExcelExport.class);
        util.exportExcel(response, tempList, "产品二维码规则数据");
    }

    /**
     * 获取产品二维码规则详细信息
     */
    @ApiOperation("获取产品二维码规则详细信息")
    @PreAuthorize("@ss.hasPermi('pro:proQrcodeRule:query')")
    @GetMapping(value = "/{ruleId}")
    public AjaxResult<ProProductQrcodeRuleDto> getInfo(@PathVariable("ruleId") Long ruleId) {
        return AjaxResult.success(proProductQrcodeRuleService.selectProProductQrcodeRuleDtoByRuleId(ruleId));
    }

    /**
     * 新增产品二维码规则
     */
    @ApiOperation("新增产品二维码规则")
    @PreAuthorize("@ss.hasPermi('pro:proQrcodeRule:add')")
    @Log(title = "产品二维码规则", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProProductQrcodeRuleCreate proProductQrcodeRuleCreate) {
        return toAjax(proProductQrcodeRuleService.insertProProductQrcodeRule(proProductQrcodeRuleCreate));
    }

    /**
     * 修改产品二维码规则
     */
    @ApiOperation("修改产品二维码规则")
    @PreAuthorize("@ss.hasPermi('pro:proQrcodeRule:edit')")
    @Log(title = "产品二维码规则", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductQrcodeRuleUpdate proProductQrcodeRuleUpdate) {
        return toAjax(proProductQrcodeRuleService.updateProProductQrcodeRule(proProductQrcodeRuleUpdate));
    }

    /**
     * 删除产品二维码规则
     */
    @ApiOperation("删除产品二维码规则")
    @PreAuthorize("@ss.hasPermi('pro:proQrcodeRule:remove')")
    @Log(title = "产品二维码规则", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ruleIds}")
    public AjaxResult remove(@PathVariable Long[] ruleIds) {
        return toAjax(proProductQrcodeRuleService.deleteProProductQrcodeRuleByRuleIds(ruleIds));
    }
}
