package com.ximai.mes.pro.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.pro.domain.ProMaterialReturn;
import com.ximai.mes.pro.service.IProMaterialReturnService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 退料申请Controller
 *
 * @author generator
 * @date 2024-02-22
 */
@RestController
@RequestMapping("/pro/materialReturn")
public class ProMaterialReturnController extends BaseController {

    @Autowired
    private IProMaterialReturnService proMaterialReturnService;

    /**
     * 查询退料申请列表
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProMaterialReturn proMaterialReturn) {
        startPage();
        List<ProMaterialReturn> list = proMaterialReturnService.selectProMaterialReturnList(proMaterialReturn);
        return getDataTable(list);
    }

    /**
     * 导出退料申请列表
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:export')")
    @Log(title = "退料申请", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProMaterialReturn proMaterialReturn) {
        List<ProMaterialReturn> list = proMaterialReturnService.selectProMaterialReturnList(proMaterialReturn);
        ExcelUtil<ProMaterialReturn> util = new ExcelUtil<>(ProMaterialReturn.class);
        util.exportExcel(response, list, "退料申请数据");
    }


    /**
     * 获取退料申请详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:query')")
    @GetMapping(value = "/{materialReturnId}")
    public AjaxResult getInfo(@PathVariable("materialReturnId") Long materialReturnId) {
        return AjaxResult.success(proMaterialReturnService.selectProMaterialReturnByMaterialReturnId(materialReturnId));
    }


    /**
     * 新增退料申请
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:add')")
    @Log(title = "退料申请", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProMaterialReturn proMaterialReturn) {
        return toAjax(proMaterialReturnService.insertProMaterialReturn(proMaterialReturn));
    }


    /**
     * 修改退料申请
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:edit')")
    @Log(title = "退料申请", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProMaterialReturn proMaterialReturn) {
        return toAjax(proMaterialReturnService.updateProMaterialReturn(proMaterialReturn));
    }


    /**
     * 删除退料申请
     */
    @PreAuthorize("@ss.hasPermi('pro:materialReturn:remove')")
    @Log(title = "退料申请", businessType = BusinessType.DELETE)
    @DeleteMapping("/{materialReturnIds}")
    public AjaxResult remove(@PathVariable Long[] materialReturnIds) {
        return toAjax(proMaterialReturnService.deleteProMaterialReturnByMaterialReturnIds(materialReturnIds));
    }
}
