package com.ximai.mes.pro.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.poi.ExcelUtil;
import com.ximai.mes.pro.domain.ProCombination;
import com.ximai.mes.pro.service.IProCombinationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 生产组合单Controller
 *
 * @author generator
 * @date 2024-02-28
 */
@RestController
@RequestMapping("/pro/combination")
public class ProCombinationController extends BaseController {
    @Autowired
    private IProCombinationService proCombinationService;


    /**
     * 查询生产组合单列表
     */
    @PreAuthorize("@ss.hasPermi('pro:combination:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProCombination proCombination) {
        startPage();
        List<ProCombination> list = proCombinationService.selectProCombinationList(proCombination);
        return getDataTable(list);
    }

    /**
     * 查询生产组合单列表
     */
    @PreAuthorize("@ss.hasPermi('pro:combination:list')")
    @GetMapping("/combList")
    public TableDataInfo getCombList(ProCombination proCombination) {
        startPage();
        List<ProCombination> list = proCombinationService.selectProCombList(proCombination);
        return getDataTable(list);
    }


    /**
     * 导出生产组合单列表
     */
    @PreAuthorize("@ss.hasPermi('pro:combination:export')")
    @Log(title = "生产组合单", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ProCombination proCombination) {
        List<ProCombination> list = proCombinationService.selectProCombinationList(proCombination);
        ExcelUtil<ProCombination> util = new ExcelUtil<ProCombination>(ProCombination.class);
        util.exportExcel(response, list, "生产组合单数据");
    }

    /**
     * 获取生产组合单详细信息
     */
    @PreAuthorize("@ss.hasPermi('pro:combination:query')")
    @GetMapping(value = "/{combinationId}")
    public AjaxResult getInfo(@PathVariable("combinationId") Long combinationId) {
        return AjaxResult.success(proCombinationService.selectProCombinationByCombinationId(combinationId));
    }

    /**
     * 新增生产组合单
     */
    @PreAuthorize("@ss.hasPermi('pro:combination:add')")
    @Log(title = "生产组合单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProCombination proCombination) {
        return toAjax(proCombinationService.insertProCombination(proCombination));
    }


    /**
     * 新增、修改生产组合单
     */
    @PreAuthorize("@ss.hasPermi('pro:combination:addorupdate')")
    @Log(title = "生产组合单", businessType = BusinessType.INSERT)
    @PostMapping("/batchAdd")
    public List<String> batchAdd(@RequestBody List<ProCombination> proCombinations) {
        return proCombinationService.batchAddProCombinationV2(proCombinations);
    }

    /**
     * 修改生产组合单
     */
    @PreAuthorize("@ss.hasPermi('pro:combination:edit')")
    @Log(title = "生产组合单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProCombination proCombination) {
        return toAjax(proCombinationService.updateProCombination(proCombination));
    }

    /**
     * 删除生产组合单
     */
    @PreAuthorize("@ss.hasPermi('pro:combination:remove')")
    @Log(title = "生产组合单", businessType = BusinessType.DELETE)
    @DeleteMapping("/{workorderIds}")
    public AjaxResult remove(@PathVariable Long[] workorderIds) {
        return toAjax(proCombinationService.deleteProCombinationByWorkorderIds(workorderIds));
    }
}
